<?php
/**
 * @package       Blank page
 * @version       2.0.1
 * @Author        Sergey Tolkachyov
 * @copyright     Copyright (c) 2018 - 2025 Sergey Tolkachyov. All rights reserved.
 * @license       GNU/GPL3 http://www.gnu.org/licenses/gpl-3.0.html
 * @link          https://web-tolk.ru/dev/components/blank-page-component-for-joomla
 * @since         1.0.0
 */

namespace Joomla\Component\Blank\Administrator\View\Blank;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use function defined;

defined('_JEXEC') or die;

class HtmlView extends BaseHtmlView
{
	public function display($tpl = null)
	{
		$this->addToolBar();
		parent::display($tpl);
	}

	protected function addToolBar()
	{
		ToolbarHelper::title(Text::_('COM_BLANK'));
		$user = Factory::getApplication()->getIdentity();
		if ($user->authorise('core.admin', 'com_blank') || $user->authorise('core.options', 'com_blank'))
		{
			ToolbarHelper::preferences('com_blank');
		}
	}
}