<?php
/**
 * @version      1.6.0 12.06.2020
 * @author       Sergey Tolkachyov
 * @copyright    Copyright (C) 2019 Sergey Tolkachyov. All rights reserved.
 * @license      GNU/GPL
 */
$version                  = "1.6.0";
$version_date             = "02.05.2022";
$addon_info               = "<div class=\"media\" style=\"box-shadow: 0 .5rem 1rem rgba(0,0,0,.15); padding:1rem; margin-bottom:2 rem;\"><div class=\"media-body\">
<h3>Расчет доставки с помощью Тарификатора Почты России</h3>
<p><a href=\"https://tariff.pochta.ru/\">Тарификатор</a> - сервис расчета стоимости доставки Почты России (для физ.лиц). В нем представлены почти все тарифы и дополнительные услуги.</p>
<p>Расширение разрабатывалось с учетом версии тарификатора <span class=\"badge badge-success bg-success\">2.11.1.659</span>. Текущая версия Тарификатора: <span class=\"badge badge-info bg-info\">" . $tariff_array["version"] . "</span></p>
<p>Аддон развивается за счет пожертвований. Вы можете поддержать дальнейшее развитие расширения <a href=\"https://web-tolk.ru/donate.html\" class=\"btn btn-small btn-primary\" target=\"_blank\"><span class=\"icon-out-2 small\"></span></a></p><p><span class=\"badge badge-dark\">Версия</span><span class=\"badge badge-success bg-success\">" . $version . "</span> | <span class=\"badge bg-dark\">Дата</span><span class=\"badge badge-success bg-success\">" . $version_date . "</span> | <a href=\"https://web-tolk.ru/dev/joomshopping/joomshopping-russian-post-shipping-method-api.html\" target=\"_blank\">Описание на сайте разработчика</a> | <a href=\"https://github.com/sergeytolkachyov/JoomShopping-Russian-Post-Shipping-method-via-API\" target=\"_blank\">GitHub</a> | <a href=\"https://web-tolk.ru/dev/joomshopping/joomshopping-russian-post-shipping-method-api/versions.html\" target=\"_blank\">Версии</a> |</p></div></div>
";
$wt_sm_otpravka_pochta_ru = "
<div class=\"alert alert-warning\"><h4>Для JoomShopping существует платная интеграция с Почтой России для бизнеса - WT SM Otpravka.pochta.ru</h4>
			<p>Расширение для расчета стоимости доставки и интеграции интернет-магазина Joomla JoomShopping с личным кабинетом сервиса Отправка Почты России для бизнеса. Расчет стоимости происходит по тарифам согласно Вашему договору с Почтой России.</p>
			<p><a href=\"https://web-tolk.ru/dev/joomshopping/wt-sm-otpravka-pochta-ru.html\" class=\"btn btn-small btn-primary\" target=\"_blank\">ПОДРОБНЕЕ</a></p>
			<ul>
			<li>В настройках Joomla JoomShopping показываются только те отделения почтовой связи и только те тарифы, которые описаны в Вашем договоре и доступны в Вашем личном кабинете. Ничего лишнего.</li>
			<li>Расчет стоимости доставки по актуальным тарифам Почты России для бизнеса.</li>
			<li>Отображение сроков доставки</li>
			<li>Отображение дополнительной информации о способе доставки (SMS-уведомления, размер НДС и т.д.)</li>
			<li>Неограниченное количество способов доставки Joomla JoomShopping с помощью Почты России</li>
			<li>Возможность наценки как на отдельный способ доставки, так и не все способы доставки сразу.</li>
			<li>Возможность указания коэффициента поправки веса как для отдельного способа доставки. так и на все сразу. В этот коэффициент закладывается вес упаковки.</li>
			<li><strong>Интеграция с Личным кабинетом Почты России для бизнеса. Отправка данных заказа.</strong></li>
			<li><strong>Получение трек-номера и показ его покупателю на странице завершения заказа JoomShopping.</strong></li>
			<li>Отображение отладочной информации на этапе расчета стоимости доставки.</li>
			<li>Возможность отключить показ способа доставки в случае возникновения ошибок.</li>
			</ul></div>
";

// добавить поле бесплатной доставки от определеннй суммы заказа
defined('_JEXEC') or die('Restricted access');
/**Бандероли**/
$minweight = 100; //Минимальный вес отправления 100 грамм
/**
 *  code - код объекта - код типа отправления
 *    desc - описание
 *    disabled - оключено ли по умолчанию
 *  pack - код типа коробки для некоторых типов отправления
 *    sumoc - возможно указать сумму объявленной стоимости
 *    sumnp - возможно указать сумму наложенного платежа
 *    countinpack - количество отправлений (для EMS)
 *    international - международное отправление
 */
$tipOtpravleniya = array(
	array(
		"code"          => "3000",
		"desc"          => "Бандероль простая",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "3010",
		"desc"          => "Бандероль заказная",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "3020",
		"desc"          => "Бандероль с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "3040",
		"desc"          => "Бандероль с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "16010",
		"desc"          => "Бандероль 1 класса заказная",
		"disabled"      => "0",
		"pack"          => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "16020",
		"desc"          => "Бандероль 1 класса с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "16040",
		"desc"          => "Бандероль 1 класса с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	), array(
		"code"          => "35010",
		"desc"          => "Бандероль-комплект",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	/**Посылки**/
	array(
		"code"          => "27030",
		"desc"          => "Посылка стандарт",
		"pack"          => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "27020",
		"desc"          => "Посылка стандарт с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "1",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "27040",
		"desc"          => "Посылка стандарт с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "1",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "29020",
		"desc"          => "Посылка стандарт с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "1",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "29040",
		"desc"          => "Посылка экспресс с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "1",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "28030",
		"desc"          => "Посылка курьер EMS",
		"pack"          => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "28020",
		"desc"          => "Посылка курьер EMS с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "1",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "28040",
		"desc"          => "Посылка курьер EMS с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "1",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "4030",
		"desc"          => "Посылка",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "4020",
		"desc"          => "Посылка с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "4040",
		"desc"          => "Посылка с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	), array(
		"code"          => "4060",
		"desc"          => "Посылка с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "47030",
		"desc"          => "Посылка 1 класса",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "47020",
		"desc"          => "Посылка 1 класса с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "47040",
		"desc"          => "Посылка 1 класса с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "1",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "47060",
		"desc"          => "Посылка 1 класса с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "1",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "23030",
		"desc"          => "Посылка онлайн обыкновенная <span class='badge badge-info bg-info'>См. инфо</span>",
		"pack"          => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "23020",
		"desc"          => "Посылка онлайн с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "23040",
		"desc"          => "Посылка онлайн с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "23060",
		"desc"          => "Посылка онлайн с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "23080",
		"desc"          => "Посылка онлайн комбинированная",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "23090",
		"desc"          => "Посылка онлайн комбинированная с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "24030",
		"desc"          => "Курьер онлайн обыкновенный <span class='badge bage-info bg-info'>См. инфо</span>",
		"pack"          => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "24020",
		"desc"          => "Курьер онлайн с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "24040",
		"desc"          => "Курьер онлайн с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "24060",
		"desc"          => "Курьер онлайн с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "30030",
		"desc"          => "Бизнес курьер <span class='badge badge-info bg-info'>См. инфо</span>",
		"pack"          => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "30020",
		"desc"          => "Бизнес курьер с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "31030",
		"desc"          => "Бизнес курьер экспресс",
		"pack"          => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "31020",
		"desc"          => "Бизнес курьер экспресс с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "51030",
		"desc"          => "Посылка <strong>Легкий возврат обыкновенная</strong> <a href='https://www.pochta.ru/support/parcels/point-online' class='badge badge-warning bg-warning' title='См. на сайте Почты России'>Инфо о тарифе</a>. <strong>37 городов, Вес MAX 15кг</strong>",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "51020",
		"desc"          => "Посылка <strong>Легкий возврат с объявленной ценностью</strong> <a href='https://www.pochta.ru/support/parcels/point-online' class='badge badge-warning bg-warning' title='См. на сайте Почты России'>Инфо о тарифе</a>. <strong>37 городов, Вес MAX 15кг</strong>",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "54020",
		"desc"          => "ЕКОМ Маркетплейс с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "54060",
		"desc"          => "ЕКОМ Маркетплейс с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),

	/**EMS**/
	array(
		"code"          => "7030",
		"desc"          => "EMS",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "7020",
		"desc"          => "EMS с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "7040",
		"desc"          => "EMS с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "1",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "7060",
		"desc"          => "EMS с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "34030",
		"desc"          => "EMS оптимальное",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "34020",
		"desc"          => "EMS оптимальное с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "34040",
		"desc"          => "EMS оптимальное с объявленной ценностью и наложенным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "34060",
		"desc"          => "EMS оптимальное с объявленной ценностью и обязательным платежом",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "0",
		"international" => "0"
	),
	array(
		"code"          => "41030",
		"desc"          => "EMS РТ",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "0"
	),
	array(
		"code"          => "41020",
		"desc"          => "EMS РТ с объявленной ценностью",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "0"
	),
	/*  Международные   */
	array(
		"code"          => "4031",
		"desc"          => "Посылка обыкновенная международная исходящая",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "4021",
		"desc"          => "Посылка с объявленной ценностью международная исходящая",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "4041",
		"desc"          => "Посылка с объявленной ценностью и наложенным платежом международная исходящая",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "1",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "7031",
		"desc"          => "EMS обыкновенное международное исходящее",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "7021",
		"desc"          => "EMS с объявленной ценностью международное исходящее",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "7041",
		"desc"          => "EMS с наложенным платежом международное исходящее",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "1",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "5001",
		"desc"          => "Мелкий пакет простой исходящий",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	),
	array(
		"code"          => "5011",
		"desc"          => "Мелкий пакет заказной исходящий",
		"disabled"      => "0",
		"pack"          => "0",
		"sumoc"         => "0",
		"sumnp"         => "0",
		"countinpack"   => "1",
		"international" => "1"
	)
);


//sumnp - сумма наложенного платежа
// countinpack - Среднее количество в пакете (шт.)
/**Упаковки**/
$pack = array(
	array(
		"code" => "10",
		"desc" => "Коробка «S»"
	),
	array(
		"code" => "11",
		"desc" => "Пакет полиэтиленовый «S»"
	),
	array(
		"code" => "12",
		"desc" => "Конверт с воздушно-пузырчатой пленкой «S»"
	),
	array(
		"code" => "20",
		"desc" => "Коробка «М»"
	),
	array(
		"code" => "21",
		"desc" => "Пакет полиэтиленовый «М»"
	),
	array(
		"code" => "22",
		"desc" => "Конверт с воздушно-пузырчатой пленкой «М»"
	),
	array(
		"code" => "30",
		"desc" => "Коробка «L»"
	),
	array(
		"code" => "31",
		"desc" => "Пакет полиэтиленовый «L»"
	),
	array(
		"code" => "40",
		"desc" => "Коробка «ХL»"
	),
	array(
		"code" => "41",
		"desc" => "Пакет полиэтиленовый «ХL»"
	)
);


$service = array(
	array("code" => "1", "desc" => "Межоператорское")
);

/*
Бандероль простая
	Межоператорское
	Обслуживание консолидаторов
Бандероль заказная.
	Межоператорское
	Простое уведомление о вручении
	Заказное уведомление о вручении
	СМС-уведомление о прибытии в отделение
	СМС-уведомление о вручении
	Обслуживание консолидаторов
Бандероль с объявленной ценностью
	Межоператорское
	Простое уведомление о вручении
	Заказное уведомление о вручении
	СМС-уведомление о прибытии в отделение
	СМС-уведомление о вручении
	Проверка соответствия вложения описи
	Обслуживание консолидаторов
Бандероль с объявленной ценностью и наложенным платежом
	Межоператорское
	Простое уведомление о вручении
	Заказное уведомление о вручении
	СМС-уведомление о прибытии в отделение
	СМС-уведомление о вручении
	Проверка соответствия вложения описи
	Обслуживание консолидаторов
Бандероль 1 класса заказная
	Простое уведомление о вручении
	Заказное уведомление о вручении
	СМС-уведомление о прибытии в отделение
	СМС-уведомление о вручении
		Доставка по звонку
		Электронное уведомление о вручении
	Обслуживание консолидаторов
Бандероль 1 класса с объявленной ценностью
	Простое уведомление о вручении
	Заказное уведомление о вручении
	СМС-уведомление о прибытии в отделение
	СМС-уведомление о вручении
	Проверка соответствия вложения описи
	Доставка по звонку
	Электронное уведомление о вручении
	Обслуживание консолидаторов
Бандероль 1 класса с объявленной ценностью и наложенным платежом
	Простое уведомление о вручении
	Заказное уведомление о вручении
	СМС-уведомление о прибытии в отделение
	СМС-уведомление о вручении
	Проверка соответствия вложения описи
	Доставка по звонку
	Электронное уведомление о вручении
	Обслуживание консолидаторов
	
Посылка стандарт
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка стандарт с объявленной ценностью
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка стандарт с объявленной ценностью и наложенным платежом
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка экспресс
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка экспресс с объявленной ценностью
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка экспресс с объявленной ценностью и наложенным платежом
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка курьер EMS
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка курьер EMS с объявленной ценностью
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка курьер EMS с объявленной ценностью и наложенным платежом
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка соответствия вложения описи
Посылка нестандартная
	Негабарит
	Отметка 'Осторожно'
	Простое уведомление о вручении
	Заказное уведомление о вручении
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка комплектности
	Курьерский сбор
Посылка нестандартная с объявленной ценностью
	Негабарит
	Отметка 'Осторожно'
	Простое уведомление о вручении
	Заказное уведомление о вручении
	Проверка соответствия вложения описи
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка комплектности
	Курьерский сбор
Посылка нестандартная с объявленной ценностью и наложенным платежом
	Негабарит
	Отметка 'Осторожно'
	Простое уведомление о вручении
	Заказное уведомление о вручении
	Проверка соответствия вложения описи
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Проверка комплектности
	Курьерский сбор
Посылка 1 класса
	Простое уведомление о вручении
	Заказное уведомление о вручении
	Пакет SMS-сервис
	Предпочтовая подготовка
	Курьерский сбор
Посылка 1 класса с объявленной ценностью
	Простое уведомление о вручении
	Заказное уведомление о вручении
	Пакет SMS-сервис
	Проверка соответствия вложения описи
	Предпочтовая подготовка
	Курьерский сбор
Посылка 1 класса с объявленной ценностью и наложенным платежом
	Простое уведомление о вручении
	Заказное уведомление о вручении
	Пакет SMS-сервис
	Проверка соответствия вложения описи
	Предпочтовая подготовка
	Курьерский сбор	
Посылка онлайн обыкновенная
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Курьерский сбор
Посылка онлайн с объявленной ценностью
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Курьерский сбор
Посылка онлайн с объявленной ценностью и наложенным платежом
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Курьерский сбор
Курьер онлайн обыкновенный
	Проверка комплектности
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Курьерский сбор
Курьер онлайн с объявленной ценностью
	Проверка комплектности
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Курьерский сбор
Курьер онлайн с объявленной ценностью и наложенным платежом
	Проверка комплектности
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Предпочтовая подготовка
	Курьерский сбор
Бизнес курьер
	Предпочтовая подготовка
	Возврат сопроводительных документов
Бизнес курьер с объявленной ценностью
	Предпочтовая подготовка
	Возврат сопроводительных документов
Бизнес курьер экспресс
	Предпочтовая подготовка
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Возврат сопроводительных документов
Бизнес курьер экспресс с объявленной ценностью
	Предпочтовая подготовка
	Пакет SMS уведомлений отправителю при единичном приеме
	Пакет SMS уведомлений получателю при единичном приеме
	Пакет SMS уведомлений отправителю при партионном приеме
	Пакет SMS уведомлений получателю при партионном приеме
	Возврат сопроводительных документов
	*/
/*
 * Коды стран в API Почты России. Большинство кодов соввпадают с ISO-3166
 */
$countries_pochta_ru_codes = array(
	"AF"    => "4",
	"AX"    => "248",
	"AL"    => "8",
	"DZ"    => "12",
	"AS"    => "16",
	"AD"    => "20",
	"AO"    => "24",
	"AI"    => "660",
	"AQ"    => "10",
	"AG"    => "28",
	"AR"    => "32",
	"AM"    => "51",
	"AW"    => "533",
	"AU"    => "36",
	"AT"    => "40",
	"AZ"    => "31",
	"BS"    => "44",
	"BH"    => "48",
	"BD"    => "50",
	"BB"    => "52",
	"BY"    => "112",
	"BE"    => "56",
	"BZ"    => "84",
	"BJ"    => "204",
	"BM"    => "60",
	"BT"    => "64",
	"BO"    => "68",
	"BQ"    => "535",
	"BA"    => "70",
	"BW"    => "72",
	"BV"    => "74",
	"BR"    => "76",
	"IO"    => "86",
	"BN"    => "96",
	"BG"    => "100",
	"BF"    => "854",
	"BI"    => "108",
	"CV"    => "132",
	"KH"    => "116",
	"CM"    => "120",
	"CA"    => "124",
	"KY"    => "136",
	"CF"    => "140",
	"TD"    => "148",
	"CL"    => "152",
	"CN"    => "156",
	"CX"    => "162",
	"CC"    => "166",
	"CO"    => "170",
	"KM"    => "174",
	"CG"    => "178",
	"CD"    => "180",
	"CK"    => "184",
	"CR"    => "188",
	"CI"    => "384",
	"HR"    => "191",
	"CU"    => "192",
	"CW"    => "531",
	"CY"    => "196",
	"CZ"    => "203",
	"DK"    => "208",
	"DJ"    => "262",
	"DM"    => "212",
	"DO"    => "214",
	"EC"    => "218",
	"EG"    => "818",
	"SV"    => "222",
	"GQ"    => "226",
	"ER"    => "232",
	"EE"    => "233",
	"SZ"    => "748",
	"ET"    => "231",
	"FK"    => "238",
	"FO"    => "234",
	"FJ"    => "242",
	"FI"    => "246",
	"FR"    => "250",
	"GF"    => "254",
	"PF"    => "258",
	"TF"    => "260",
	"GA"    => "266",
	"GM"    => "270",
	"GE"    => "268",
	"DE"    => "276",
	"GH"    => "288",
	"GI"    => "292",
	"GR"    => "300",
	"GL"    => "304",
	"GD"    => "308",
	"GP"    => "312",
	"GU"    => "316",
	"GT"    => "320",
	"GG"    => "831",
	"GN"    => "324",
	"GW"    => "624",
	"GY"    => "328",
	"HT"    => "332",
	"HM"    => "334",
	"VA"    => "336",
	"HN"    => "340",
	"HK"    => "344",
	"HU"    => "348",
	"IS"    => "352",
	"IN"    => "356",
	"ID"    => "360",
	"IR"    => "364",
	"IQ"    => "368",
	"IE"    => "372",
	"IM"    => "833",
	"IL"    => "376",
	"IT"    => "380",
	"JM"    => "388",
	"JP"    => "392",
	"JE"    => "832",
	"JO"    => "400",
	"KZ"    => "398",
	"KE"    => "404",
	"KI"    => "296",
	"KP"    => "408",
	"KR"    => "410",
	"KW"    => "414",
	"KG"    => "417",
	"LA"    => "418",
	"LV"    => "428",
	"LB"    => "422",
	"LS"    => "426",
	"LR"    => "430",
	"LY"    => "434",
	"LI"    => "438",
	"LT"    => "440",
	"LU"    => "442",
	"MO"    => "446",
	"MG"    => "450",
	"MW"    => "454",
	"MY"    => "458",
	"MV"    => "462",
	"ML"    => "466",
	"MT"    => "470",
	"MH"    => "584",
	"MQ"    => "474",
	"MR"    => "478",
	"MU"    => "480",
	"YT"    => "175",
	"MX"    => "484",
	"FM"    => "583",
	"MD"    => "498",
	"MC"    => "492",
	"MN"    => "496",
	"ME"    => "499",
	"MS"    => "500",
	"MA"    => "504",
	"MZ"    => "508",
	"MM"    => "104",
	"NA"    => "516",
	"NR"    => "520",
	"NP"    => "524",
	"NL"    => "528",
	"NC"    => "540",
	"NZ"    => "554",
	"NI"    => "558",
	"NE"    => "562",
	"NG"    => "566",
	"NU"    => "570",
	"NF"    => "574",
	"MK"    => "807",
	"MP"    => "580",
	"NO"    => "578",
	"OM"    => "512",
	"PK"    => "586",
	"PW"    => "585",
	"PS"    => "275",
	"PA"    => "591",
	"PG"    => "598",
	"PY"    => "600",
	"PE"    => "604",
	"PH"    => "608",
	"PN"    => "612",
	"PL"    => "616",
	"PT"    => "620",
	"PR"    => "630",
	"QA"    => "634",
	"RE"    => "638",
	"RO"    => "642",
	"RU"    => "643",
	"RW"    => "646",
	"BL"    => "652",
	"SH"    => "654",
	"KN"    => "659",
	"LC"    => "662",
	"MF"    => "663",
	"PM"    => "666",
	"VC"    => "670",
	"WS"    => "882",
	"SM"    => "674",
	"ST"    => "678",
	"SA"    => "682",
	"SN"    => "686",
	"RS"    => "688",
	"SC"    => "690",
	"SL"    => "694",
	"SG"    => "702",
	"SX"    => "534",
	"SK"    => "703",
	"SI"    => "705",
	"SB"    => "90",
	"SO"    => "706",
	"ZA"    => "710",
	"GS"    => "239",
	"SS"    => "728",
	"ES"    => "724",
	"LK"    => "144",
	"SD"    => "729",
	"SR"    => "740",
	"SJ"    => "744",
	"SE"    => "752",
	"CH"    => "756",
	"SY"    => "760",
	"TW"    => "158",
	"TJ"    => "762",
	"TZ"    => "834",
	"TH"    => "764",
	"TL"    => "626",
	"TG"    => "768",
	"TK"    => "772",
	"TO"    => "776",
	"TT"    => "780",
	"TN"    => "788",
	"TR"    => "792",
	"TM"    => "795",
	"TC"    => "796",
	"TV"    => "798",
	"UG"    => "800",
	"UA"    => "804",
	"AE"    => "784",
	"GB"    => "826",
	"US"    => "840",
	"UM"    => "581",
	"UY"    => "858",
	"UZ"    => "860",
	"VU"    => "548",
	"VE"    => "862",
	"VN"    => "704",
	"VG"    => "92",
	"VI"    => "850",
	"WF"    => "876",
	"EH"    => "732",
	"YE"    => "887",
	"ZM"    => "894",
	"ZW"    => "716",
	"GE-AB" => "895"

);
?>