<?php
/**
 * @package     WebTolk plugin info field
 * @version     1.0.0
 * @Author 		Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
 * @since 		1.0.0
 */

defined('_JEXEC') or die;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use \Joomla\CMS\Factory;
FormHelper::loadFieldClass('note');

class JFormFieldWtsmozonrocketkeyinfo extends JFormFieldNote
{

	protected $type = 'wtsmozonrocketkeyinfo';

	/**
	 * Method to get the field input markup for a spacer.
	 * The spacer does not have accept input.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   1.7.0
	 */
	protected function getInput()
	{

		$plugin = PluginHelper::getPlugin('system','wtlicensemanager');
		$params = json_decode($plugin->params);
		$html = '<p>';

		$domain = $params->wt_sm_ozon_rocket_domain;
		$current_uri = JUri::getInstance();
		$current_domain = $current_uri->getHost();
		$timezone = Factory::getUser()->getTimezone();

		if(strpos($domain,$current_domain)=== false && $domain){
			$html .= '<span class="label label-important">'.Text::_('PLG_WTLICENSEMANAGER_KEY_WRONG_DOMAIN_WARN').'</span> ';
		} else {
			$html .= '<span class="label label-success">OK</span> '.Text::_('PLG_WTLICENSEMANAGER_KEY_DOMAIN_OK');
		}

		if(!empty($params->wt_sm_ozon_rocket_date_start)){

			$html .= '<span class="label label-success">'.Text::_('PLG_WTLICENSEMANAGER_KEY_DATE_START').'</span><span class="label label-info" id="wt_sm_ozon_rocket_date_start">'.$params->wt_sm_ozon_rocket_date_start.'</span> ';
		}

		if(!empty($params->wt_sm_ozon_rocket_date_end)){
			$date_end = new Date($params->wt_sm_ozon_rocket_date_end);
			$date_end->setTimezone($timezone);
			$date_end->format('d.m.Y');
			//echo $ostatok = new Date($date_end .' - 30days');
			$html .= '<span class="label label-success">'.Text::_('PLG_WTLICENSEMANAGER_KEY_DATE_END').'</span><span class="label label-info" id="wt_sm_ozon_rocket_date_end">'.$date_end.'</span>';
		}

		$js = '
			jQuery(document).ready(function (){
				
                jQuery("#jform_params_wt_sm_ozon_rocket_key").keyup(function(){
            			let wt_sm_ozon_rocket_key = jQuery("#jform_params_wt_sm_ozon_rocket_key").val();
                        Joomla.request({
                            url: "https://web-tolk.ru/index.php?option=com_ajax&plugin=wt_get_sw_jprojects_key_info&group=system&format=json&element=pkg_wtsmozonrocket&download_key="+wt_sm_ozon_rocket_key,
                            onSuccess: function(response, xhr){
                                    let result = JSON.parse(response);
                                    let data = JSON.parse(result.data);

                                    if(data.domain){
                                        jQuery("#jform_params_wt_sm_ozon_rocket_domain").val(data.domain);
                                    }
                                    if(data.date_start){
                                        jQuery("#jform_params_wt_sm_ozon_rocket_date_start").val(data.date_start);
                                        jQuery("#wt_sm_ozon_rocket_date_start").html(data.date_start);
                                    }
                                    if(data.date_end){
                                        jQuery("#jform_params_wt_sm_ozon_rocket_date_end").val(data.date_end);
                                        jQuery("#wt_sm_ozon_rocket_date_end").html(data.date_end);
                                    }
                                    if(data.error){
                                        console.error("WT SM Ozon Rocket key info: " + data.error.code + " - " + data.error.description)
                                        Joomla.renderMessages({"error":["<span class=\"alert-link\">WT SM Ozon Rocket key info:</span> " + data.error.code + " - " + data.error.description]});
                                        jQuery("#wt_sm_ozon_rocket_date_end").html("");
                                        jQuery("#jform_params_wt_sm_ozon_rocket_date_end").val("");
                                        jQuery("#jform_params_wt_sm_ozon_rocket_date_start").val("");
                                        jQuery("#jform_params_wt_sm_ozon_rocket_domain").val("");
	                                    jQuery("#wt_sm_ozon_rocket_date_start").html("");
                                    } else {
                                        Joomla.renderMessages({"success":["<span class=\"alert-link\">WT SM Ozon Rocket key info:</span> '.Text::_('PLG_WTLICENSEMANAGER_KEY_OK').'"]});
                                    }
   
                                },
                            onError: function(xhr){
	                               console.log (xhr);
	                               Joomla.renderMessages({"warning":["<span class=\"alert-link\">WT SM Ozon Rocket key info:</span> '.Text::_('PLG_WTLICENSEMANAGER_ERROR_FETCH_DATA_FROM_WEBTOLK').'"]});
                                }
                        });
                        
                });
                
			});
			
			

		';
		Factory::getDocument()->addScriptDeclaration($js);

		return '</p>'.$html;
	}

	/**
	 * @return  string  The field label markup.
	 *
	 * @since   1.7.0
	 */
	protected function getLabel()
	{
		return Text::_('PLG_WTLICENSEMANAGER_KEY_INFO');
	}

	/**
	 * Method to get the field title.
	 *
	 * @return  string  The field title.
	 *
	 * @since   1.7.0
	 */
	protected function getTitle()
	{
		return $this->getLabel();
	}

}
?>