<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Module\Wtjshoppinglastseenproducts\Site\Helper\WtjshoppinglastseenproductsHelper;


if (!file_exists(JPATH_SITE . '/administrator/components/com_jshopping/jshopping.xml'))
{
	throw new Exception('Please install JoomShopping', 500);
}
if(!class_exists('JSHelper')){
	require_once(JPATH_SITE . '/components/com_jshopping/bootstrap.php');
}

if (PluginHelper::isEnabled('jshoppingproducts', 'wt_jshopping_last_seen_products') == false)
{
	$app = Factory::getApplication();
	$app->enqueueMessage('<h5>WT Jshopping last seen products module</h5><p>Please, enable WT Jshopping last seen products plugin for module work.</p>', 'warning');

	return;
}

$jshopConfig = \JSFactory::getConfig();

$products        = WtjshoppinglastseenproductsHelper::getLastSeenProducts($params);
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

if($products){
	require ModuleHelper::getLayoutPath('mod_wtjshoppinglastseenproducts', $params->get('layout', 'default'));
}

