<?php
/**
 * @package    WT JoomShopping Last Seen Products
 * @author     Sergey Tolkachyov info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;

/**
 * The base class of plugin
 *
 * @package  WT JoomShopping last seen products
 * @since    1.0
 */
class PlgJshoppingproductsWt_jshopping_last_seen_products extends CMSPlugin
{
	/**
	 * Method to store last seen products
	 *
	 * @param   object  &$product  JoomShopping product
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function onAfterDisplayProduct(&$product)
	{

		//Получаем cookie с записанными id просмотренных товаров.
		$app = Factory::getApplication();
		$cookie = unserialize($app->input->cookie->get('wt_jshopping_last_seen_products', null, $filter = 'string'));

		//id текущего товара
		$product_id = $product->product_id;
		//Сколько дней хранить в cookie просмотренные товары
		$cookie_period = time()+60*60*24*(int)$this->params->get('cookie_period','1');
			//cookie есть, товара там ещё нет
			if((array_search($product_id,(array)$cookie)) === false){
				$cookie[] = $product_id;
				$cookie = serialize($cookie);
			} else {
				$prod_arr_key = array_search($product_id,$cookie);
				unset ($cookie[$prod_arr_key]);
				$cookie[] = $product_id;
				$cookie = serialize($cookie);
			}
		//Пишем итог в cookie
		$app->input->cookie->set('wt_jshopping_last_seen_products', $cookie, $cookie_period,'/');

	}

}
