<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_wt_quick_links
 *
 * @copyright   Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;

defined('_JEXEC') or die;


/**
 * Module settings:
 * 1. Show module title - yes
 * 2. Module style - html5
 * 3. module tag - section
 * 4. module suffix -  row row-cols-2 row-cols-lg-4
 * @see https://getbootstrap.com/docs/4.6/layout/grid/#row-columns
 * @see https://getbootstrap.com/docs/4.6/components/card/#grid-cards
 *
 *      Variables
 *  $item->link_text
 *  $item->link_image
 *  $item->link_icon_css
 *  $item->link_additional_text
 *  $item->media_type
 *  $item->responsive_images
 *  $item->link_video
 *  $item->link_video_poster
 *  $item->is_responsive_videos
 *  $item->responsive_videos
 */
?>


<a class="col-12 col-md mb-3" href="katalog-pamyatnikov.html">
<div class="d-flex">
  <div class="flex-shrink-1">
    <img class="mr-3" src="images/icon-1400-64x64.png" alt="Более 1400 видов памятников на могилу" />
  </div>
  <div class="flex-grow-2 ms-3 font-weight-bold">
    Более 1400 видов памятников на могилу
  </div>
</div>
</a>

<a class="col-12 col-md mb-3" href="vip-pamyatniki.html">
<div class="d-flex">
  <div class="flex-shrink-1">
    <img class="mr-3" src="images/icon-hd-64x64.png" alt="Высокоточные станки изготовят памятник с поразительной четкостью" />
  </div>
  <div class="flex-grow-2 ms-3 font-weight-bold">
   VIP памятники с HD детализацией
  </div>
</div>
</a>

<a class="col-12 col-md mb-3" href="poleznaya-informatsiya/3d-modelirovanie.html">
<div class="d-flex">
  <div class="flex-shrink-1">
    <img class="mr-3" src="images/icon-3d-64x64.png" alt="Мы делаем для Вас 3д модель памятника, чтобы Вам легче было представить мемориальный комплекс" />
  </div>
  <div class="flex-grow-2 ms-3 font-weight-bold">
    3D-моделирование памятника прямо при Вас
  </div>
</div>
</a>

<a class="col-12 col-md mb-3" href="about.html">
	<div class="d-flex">
		<div class="flex-shrink-1">
			<img class="mr-3" src="images/icon-2007-64x64.png" alt="Синай-С изготавливает памятники на могилу с 2007 года в Саратове и Энгельсе" />
		</div>
		<div class="flex-grow-2 ms-3 font-weight-bold">
			C 2007 года ставим памятники по всей области
		</div>
	</div>
</a>
<?php foreach ($list as $item) : ?>
	<article class="col p-0 p-md-3 mb-3">
		<div class="card bg-transparent shadow-hover h-100 mainpage-cards">
			<div class="card-body p-0 text-center">
				<a href="<?php echo $item->url; ?>" title="<?php echo $item->link_additional_text;?>">
					<?php

					echo HTMLHelper::image($item->link_image, $item->link_text, [
						'loading' => 'lazy',
						'class'   => 'card-img-top'
					]);

					?>

					<h3 class="h5"><?php echo $item->link_text; ?></h3>
				</a>
			</div>
		</div>
	</article>
<?php endforeach; ?>

