<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Editors-xtd.article
 *
 * @copyright   Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Session\Session;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Pagination\Pagination;

/**
 * Editor Article button
 *
 * @since  1.5
 */
class PlgButtonWtjshoppingproductsanywhere extends CMSPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * Display the button
	 *
	 * @param   string  $name  The name of the button to add
	 *
	 * @return  JObject  The button options as JObject
	 *
	 * @since   1.5
	 */
	public function onDisplay($name)
	{

		$app = Factory::getApplication();
		if (!$app->isClient('administrator'))
		{
			return;
		}

		$user = Factory::getUser();

		// Can create in any category (component permission) or at least in one category
		$canCreateRecords = $user->authorise('core.create', 'com_content')
			|| count($user->getAuthorisedCategories('com_content', 'core.create')) > 0;

		// Instead of checking edit on all records, we can use **same** check as the form editing view
		$values           = (array) Factory::getApplication()->getUserState('com_content.edit.article.id');
		$isEditingRecords = count($values);

		// This ACL check is probably a double-check (form view already performed checks)
		$hasAccess = $canCreateRecords || $isEditingRecords;
		if (!$hasAccess)
		{
			return;
		}
        $doc = Factory::getDocument();
        $doc->addStyleDeclaration('
            .btn-web-tolk {
                    background-color: #0FA2E6;
                    color:#fff;
                    border: 1px solid rgba(0,0,0,0.2);
                    transition: all linear .3s;
                } 
                .btn-web-tolk:hover, .btn-web-tolk:focus, .btn-web-tolk:active {
                    background-color: #384148;
                    color:#fff;
                    border: 1px solid rgba(0,0,0,0.2);
                }
        ');
		$link = 'index.php?option=com_ajax&amp;plugin=wtjshoppingproductsanywhere&amp;group=editors-xtd&amp;format=html&amp;tmpl=component&amp;' . Session::getFormToken() . '=1&amp;editor=' . $name;
		require_once(JPATH_SITE . '/components/com_jshopping/lib/factory.php');
		require_once(JPATH_SITE . '/components/com_jshopping/lib/functions.php');
		$current_lang = JSFactory::getLang()->lang;
		JSFactory::loadAdminLanguageFile($current_lang);
		$button          = new CMSObject();
		$button->modal   = true;
		$button->class   = 'btn btn-web-tolk';
		$button->link    = $link;
		$button->text    = _JSHOP_PRODUCTS.' JoomShopping';
		$button->name    = 'cart';
		$button->options = "{handler: 'iframe', size: {x: 800, y: 500}}";

		return $button;

	}

	public function onAjaxWtjshoppingproductsanywhere()
	{
		$app = Factory::getApplication();

		if ($app->isClient('site'))
		{
			Session::checkToken('get') or die(Text::_('JINVALID_TOKEN'));
		}

		require_once(JPATH_SITE . '/components/com_jshopping/lib/factory.php');
		require_once(JPATH_SITE . '/components/com_jshopping/lib/functions.php');
		$current_lang = JSFactory::getLang()->lang;
		JSFactory::loadAdminLanguageFile($current_lang);

		$jshopConfig = JSFactory::getConfig();
		BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_jshopping/models');
		$products = JSFactory::getModel("products");


		$context = "jshoping.list.admin.product";
		$limit   = $app->getUserStateFromRequest($context . 'limit', 'limit', $app->getCfg('list_limit'), 'int');

		$limitstart       = $app->getUserStateFromRequest($context . 'limitstart', 'limitstart', 0, 'int');
		$filter_order     = $app->getUserStateFromRequest($context . 'filter_order', 'filter_order', $jshopConfig->adm_prod_list_default_sorting, 'cmd');
		$filter_order_Dir = $app->getUserStateFromRequest($context . 'filter_order_Dir', 'filter_order_Dir', $jshopConfig->adm_prod_list_default_sorting_dir, 'cmd');

		if (isset($_GET['category_id']) && $_GET['category_id'] === "0")
		{
			$app->setUserState($context . 'category_id', 0);
			$app->setUserState($context . 'manufacturer_id', 0);
			$app->setUserState($context . 'vendor_id', -1);
			$app->setUserState($context . 'label_id', 0);
			$app->setUserState($context . 'publish', 0);
			$app->setUserState($context . 'text_search', '');
		}

		$category_id     = $app->getUserStateFromRequest($context . 'category_id', 'category_id', 0, 'int');
		$manufacturer_id = $app->getUserStateFromRequest($context . 'manufacturer_id', 'manufacturer_id', 0, 'int');
		$vendor_id       = $app->getUserStateFromRequest($context . 'vendor_id', 'vendor_id', -1, 'int');
		$label_id        = $app->getUserStateFromRequest($context . 'label_id', 'label_id', 0, 'int');
		$publish         = $app->getUserStateFromRequest($context . 'publish', 'publish', 0, 'int');
		$text_search     = $app->getUserStateFromRequest($context . 'text_search', 'text_search', '');
		if ($category_id && $filter_order == 'category')
		{
			$filter_order = 'product_id';
		}

		$filter  = array("category_id" => $category_id, "manufacturer_id" => $manufacturer_id, "vendor_id" => $vendor_id, "label_id" => $label_id, "publish" => $publish, "text_search" => $text_search);
		$total   = $products->getCountAllProducts($filter);
		$pageNav = new Pagination($total, $limitstart, $limit);
		$rows    = $products->getAllProducts(
			$filter,
			$pageNav->limitstart,
			$pageNav->limit,
			$filter_order,
			$filter_order_Dir,
			array(
				'label_image' => 1,

			)
		);
		$lists   = array(
			'treecategories' => JHTML::_('select.genericlist', JshopHelpersSelectOptions::getCategories(), 'category_id', 'class="chosen-select" onchange="document.adminForm.submit();"', 'category_id', 'name', $category_id),
			'manufacturers'  => JHTML::_('select.genericlist', JshopHelpersSelectOptions::getManufacturers(), 'manufacturer_id', 'class="chosen-select" onchange="document.adminForm.submit();"', 'manufacturer_id', 'name', $manufacturer_id),
			'publish'        => JHTML::_('select.genericlist', JshopHelpersSelectOptions::getPublish(), 'publish', 'style="width: 100px;" class="chosen-select" onchange="document.adminForm.submit();"', 'id', 'name', $publish)
		);

		if ($jshopConfig->admin_show_product_labels)
		{
			$lists['labels'] = JHTML::_('select.genericlist', JshopHelpersSelectOptions::getLabels(), 'label_id', 'style="width: 100px;" class="chosen-select" onchange="document.adminForm.submit();"', 'id', 'name', $label_id);
		}

		$dispatcher = JDispatcher::getInstance();
		$dispatcher->trigger('onBeforeDisplayListProducts', array(&$rows));

		HTMLHelper::_('behavior.core');
		HTMLHelper::_('behavior.polyfill', array('event'), 'lt IE 9');
		$doc = JFactory::getDocument();
		$doc->addScript(Juri::root() . "plugins/editors-xtd/wtjshoppingproductsanywhere/js/wtjshoppingproductsanywhere.js");

		HTMLHelper::_('behavior.multiselect');
		HTMLHelper::_('formbehavior.chosen', 'select');
		$editor                         = $app->input->getCmd('editor', '');
		$wt_wtjshoppingproductsanywhere = JFolder::files(JPATH_SITE . "/plugins/content/wt_jshopping_products_anywhere/tmpl");
		$options                        = array();
		foreach ($wt_wtjshoppingproductsanywhere as $file)
		{
			if (JFile::getExt($file) == "php")
			{
				$wt_layout = JFile::stripExt($file);
				$options[] = HTMLHelper::_('select.option', $wt_layout, $wt_layout);
			}
		}

		if (!empty($editor))
		{

			Factory::getDocument()->addScriptOptions('xtd-wtjshoppingproductsanywhere', array('editor' => $editor));
		}

		$i = 0;
		JHtml::_('formbehavior.chosen', '.chosen-select');
		$editor = $app->input->get('editor');
		?>
        <style>
            .wtjshoppingproductsanywhere_header {
                position: fixed;
                top: 0px;
                background-color: #fff;
                width: 100%;
                display: block;
                padding-bottom: 5px;
            }
            .container-popup {
                display: flex; flex-direction: column; padding: 0px;
            }
            .wtjshoppingproductsanywhere_header .media{
                background-color:#EBF0F3; padding:5px;
            }

            .wtjshoppingproductsanywhere_footer {
                position:fixed; bottom:0px; padding:10px; display: flex; width:100%; background-color: #fff; border-top:1px solid #ccc;
            }

        </style>
        <div class="container-popup">
            <form action="index.php?option=com_ajax&plugin=wtjshoppingproductsanywhere&group=editors-xtd&format=html&tmpl=component&<?php echo Session::getFormToken(); ?>=1&editor=<?php echo $editor; ?>"
                  id="adminForm" name="adminForm">
                <input type="hidden" name="option" value="com_ajax"/>
                <input type="hidden" name="plugin" value="wtjshoppingproductsanywhere"/>
                <input type="hidden" name="group" value="editors-xtd"/>
                <input type="hidden" name="format" value="html"/>
                <input type="hidden" name="tmpl" value="component"/>
                <input type="hidden" name="<?php echo Session::getFormToken(); ?>" value="1"/>
                <input type="hidden" name="editor" value="<?php echo $editor; ?>"/>
                <div class="wtjshoppingproductsanywhere_header">
                    <div class="media">
                        <img src="<?php echo JUri::root();?>/administrator/components/com_jshopping/images/jshop_logo.jpg" class="media-object pull-left" style="height:45px"/>
                        <div class="media-body">
                            <h3><?php echo _JSHOP_PRODUCTS;?> JoomShopping</h3>
                        </div>
                    </div>

                    <div style="display:flex; flex-direction: column; padding:10px;">
                        <div style="display:flex;">
                            <div>
                                <label for="wtjshoppingproductsanywhere_layout"><strong>tmpl</strong> option:
									<?php echo HTMLHelper::_("select.genericlist", $options, $name = "wtjshoppingproductsanywhere_layout", null, $key = 'value', $text = 'text', $selected = "default"); ?>
                                </label>
                            </div>
                            <div class="input-append">
                                <input class="span5" id="text_search" type="text" name="text_search"
									<?php if (!empty($text_search))
									{
										echo 'value="' . $text_search . '"';
									}
									?>
                                />
                                <button class="btn" type="submit"><i class="icon-search"></i></button>
                                <button class="btn" type="button"
                                        onclick="document.getElementById('text_search').value='';this.form.submit();"><i
                                            class="icon-remove"></i></button>
                            </div>
                        </div>
                        <div style="display:flex;">
							<?php
							foreach ($lists as $key => $value)
							{
								echo $value;
							}
							?>
                        </div>
                    </div>


                </div>

                <table class="table table-striped table-bordered" style="margin-top:130px;">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo _JSHOP_IMAGE; ?></th>
                        <th><?php echo _JSHOP_PRODUCT; ?></th>
                        <th><?php echo _JSHOP_CATEGORY; ?></th>
                        <th><?php echo _JSHOP_MANUFACTURER; ?></th>
                        <th><?php echo _JSHOP_EAN; ?></th>
                        <th><?php echo _JSHOP_PRICE; ?></th>
                        <th><?php echo _JSHOP_ID; ?></th>
                    </tr>
                    </thead>
                    <tbody>
					<?php foreach ($rows as $row): ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td>
								<?php echo $pageNav->getRowOffset($i); ?>
                            </td>
                            <td>
								<?php if ($row->label_id) { ?>
                                    <div class="product_label">
										<?php if (isset($row->_label_image) && $row->_label_image) { ?>
                                            <img src="<?php print $row->_label_image ?>" width="25" alt=""/>
										<?php } else { ?>
                                            <span class="label_name"><?php print $row->_label_name; ?></span>
										<?php } ?>
                                    </div>
								<?php } ?>
								<?php if ($row->image) { ?>
                                    <a href="#" class="select-link" data-function="jWTSelectJShoppingProduct"
                                       data-product-id="<?php print $row->product_id ?>">
                                        <img src="<?php print getPatchProductImage($row->image, 'thumb', 1) ?>"
                                             width="120"/>
                                    </a>
								<?php } ?>
                            </td>
                            <td>
                                <b><a href="#" data-function="jWTSelectJShoppingProduct" class="select-link"
                                      data-product-id="<?php print $row->product_id ?>"><?php echo $row->name; ?></a></b>
                                <div><?php echo $row->short_description; ?></div>
                            </td>
							<?php print $row->tmp_html_col_after_title ?>

                            <td>
								<?php echo $row->namescats; ?>
                            </td>
                            <td>
								<?php echo $row->man_name; ?>
                            </td>
                            <td>
								<?php echo $row->ean ?>
								<?php if ($this->config->admin_product_list_manufacture_code && $row->manufacturer_code != '') { ?>
                                    (<?php print $row->manufacturer_code ?>)
								<?php } ?>
                            </td>

                            <td>
								<?php echo formatprice($row->product_price, sprintCurrency($row->currency_id)); ?>
                            </td>
                            <td class="center">
								<?php echo $row->product_id; ?>
                            </td>
                        </tr>
						<?php
						$i++;
					endforeach;
					?>


                    </tbody>
                    <tfoot>
                    <tr>
						<?php print $this->tmp_html_col_before_td_foot ?>
                        <td colspan="7">
                            <div class="jshop_list_footer"><?php echo $pageNav->getListFooter(); ?></div>
                        </td>
                        <td>
                            <div class="jshop_limit_box"><?php echo $pageNav->getLimitBox(); ?></div>
                        </td>
						<?php print $this->tmp_html_col_after_td_foot ?>
                    </tr>
                    </tfoot>
                </table>
            </form>
            <div class="wtjshoppingproductsanywhere_footer">
                <span style="margin-left:auto; margin-right:30px;">
                    <a href="https://web-tolk.ru" target="_blank" style="display: inline-flex; align-items: center;">
							<svg width="85" height="18" xmlns="http://www.w3.org/2000/svg">
								 <g>
								  <title>Go to https://web-tolk.ru</title>
								  <text font-weight="bold" xml:space="preserve" text-anchor="start"
                                        font-family="Helvetica, Arial, sans-serif" font-size="18" id="svg_3" y="18"
                                        x="8.152073" stroke-opacity="null" stroke-width="0" stroke="#000"
                                        fill="#0fa2e6">Web</text>
								  <text font-weight="bold" xml:space="preserve" text-anchor="start"
                                        font-family="Helvetica, Arial, sans-serif" font-size="18" id="svg_4" y="18"
                                        x="45" stroke-opacity="null" stroke-width="0" stroke="#000"
                                        fill="#384148">Tolk</text>
								 </g>
							</svg>
                        <span>WT JShopping products anywhere</span>
				</a></span>
            </div>
        </div>
		<?php

		//$app->close();
	}
}
