<?php
/**
 * @package     WT JoomShopping Favorite
 * @version     1.0.0
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on coockies.
 * @Author Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since 1.0.0
 */
defined('_JEXEC') or die;

$moduleId = $module->id;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8');
$doc = \Joomla\CMS\Factory::getDocument();
$doc->addStyleSheet("modules/mod_wtjshoppingfavorites/css/style.css");
$app = JFactory::getApplication();
$product_ids = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));
if($product_ids == false){
	unset($product_ids);
}

function getItemid( $component, $view )
{
	$items = JFactory::getApplication()->getMenu( 'site' )->getItems( 'component', $component );
	foreach ( $items as $item ) {
		if($item->query['view'] === $view){
			return $item->id;
		}
	}
}

$itemid = getItemid( 'com_jshopping', 'wtjshoppingfavorites' );
if(empty($itemid) || is_null($itemid)){
	$itemid = "&Itemid=0";
} else {
	$itemid = "&Itemid=".$itemid;
}

$plugin = JPluginHelper::getPlugin('jshoppingproducts', 'wtjshoppingfavorites');
if ($plugin) {
    $pluginParams = new JRegistry($plugin->params);
	$btn_icon_css_class = $pluginParams->get("btn_icon_css_class");
}

require JModuleHelper::getLayoutPath('mod_wtjshoppingfavorites', $params->get('layout', 'default'));
