<?php

/*
*   Copyright (C) 2021  Sergey Tolkachyov
*   Released under GNU GPL Public License
*   License: http://www.gnu.org/copyleft/gpl.html
*   https://web-tolk.ru
*/

namespace Joomla\Plugin\Content\Wtarticlewithfields\Extension;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Event\SubscriberInterface;

final class Wtarticlewithfields extends CMSPlugin implements SubscriberInterface
{
    /**
     * If true, language files will be loaded automatically.
     *
     * @var    boolean
     * @since  3.9.0
     */
    protected $autoloadLanguage = true;

    protected $allowLegacyListeners = false;

    /**
     * Returns an array of events this subscriber will listen to.
     *
     * @return  array
     *
     * @since   4.0.0
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepare' => 'onContentPrepare',
        ];
    }

    /**
     * Plugin that change short code to article data with specified layout
     *
     * @param string $context The context of the content being passed to the plugin.
     * @param object &$article The article object.  Note $article->text is also available
     * @param mixed &$params The article params
     * @param integer $limitstart The 'page' number
     *
     * @return  void
     *
     * @since   1.6
     */

    public function onContentPrepare($event)
    {

        $context = $event->getArgument('0'); // $context
        $article = $event->getArgument('1'); // $article
        $params = $event->getArgument('2'); // $params
        $limitstart = $event->getArgument('3'); // $limitstart

        if ($context == 'com_finder.indexer') {
            return true;
        }

        //Проверка есть ли строка замены в контенте
        if (strpos($article->text, 'wt_article_wf') === false) {
            return;
        }


        $regex = '/{wt_article_wf\s(.*?)}/i';
        preg_match_all($regex, $article->text, $short_codes);

        $i = 0;
        $short_code_params = [];

        foreach ($short_codes[1] as $short_code) {

            $settings = explode(" ", $short_code);

            foreach ($settings as $param) {
                $param = explode("=", $param);
                $short_code_params[$param[0]] = $param[1];

            }
            if (!empty($short_code_params["article_id"])) {

                $tmpl = (!empty($short_code_params["tmpl"]) ? $short_code_params["tmpl"] : 'default');

                $model = $this->getApplication()
                    ->bootComponent('com_content')
                    ->getMVCFactory()
                    ->createModel('Article', 'Site', ['ignore_request' => false]);
                $insert_article = $model->getItem((int)$short_code_params["article_id"]);

                if (!empty($insert_article)) {
                    $insert_article->jcfields = FieldsHelper::getFields("com_content.article", $insert_article, true);
                    ob_start();
                    if (file_exists(JPATH_SITE . '/plugins/content/wtarticlewithfields/tmpl/' . $tmpl . '.php')) {
                        require JPATH_SITE . '/plugins/content/wtarticlewithfields/tmpl/' . $tmpl . '.php';
                    } else {
                        require JPATH_SITE . '/plugins/content/wtarticlewithfields/tmpl/default.php';
                    }
                    $html = ob_get_clean();

                } else {
                    $html = '';
                }
                $insert_article_sef_link = Route::_("index.php?option=com_content&view=article&id=" . $insert_article->id . "&catid=" . $insert_article->catid);
                $article->text = str_replace($short_codes[0][$i], $html, $article->text);

            } else {
                return;
            }
            $i++;
        }
    }
}