<?php
/**
 * @package     WT Yandex Map items
 *
 * @copyright   (C) 2022 Sergey Tolkachyov
 * @link https://web-tolk.ru
 * @license     GNU General Public License version 2 or later
 */

namespace Joomla\Module\Wtjshoppinglastseenproducts\Site\Dispatcher;

\defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\Module\Wtjshoppinglastseenproducts\Site\Helper\WtjshoppinglastseenproductsHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\Jshopping\Site\Lib\JSFactory;

/**
 * Dispatcher class for mod_Wtjshoppinglastseenproducts
 *
 * @since  1.0.0
 */
class Dispatcher extends AbstractModuleDispatcher
{


    /**
     * Returns the layout data.
     *
     * @return  array
     *
     * @since   1.0.0
     */
    protected function getLayoutData()
    {

        $app = Factory::getApplication();
        if (!file_exists(JPATH_SITE . '/administrator/components/com_jshopping/jshopping.xml'))
        {
            $app->enqueueMessage('<h5>WT Jshopping last seen products module</h5><p>Please install JoomShopping.</p>', 'warning');
            return false;
        }

        if (PluginHelper::isEnabled('jshoppingproducts', 'wt_jshopping_last_seen_products') == false)
        {

            $app->enqueueMessage('<h5>WT Jshopping last seen products module</h5><p>Please, enable WT Jshopping last seen products plugin for module work.</p>', 'warning');

            return false;
        }
        $data = parent::getLayoutData();
        $data['products'] = (new WtjshoppinglastseenproductsHelper)->getLastSeenProducts($data['params'], $this->getApplication());
        $data['moduleclass_sfx'] = (!empty($data['params']->get('moduleclass_sfx'))) ?? htmlspecialchars($data['params']->get('moduleclass_sfx'));
        $data['jshopConfig'] = \JSFactory::getConfig();
        return $data;
    }
}