<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * jmoodle login landing script
 *
 * @package    auth_jmoodle
 * @copyright  2009 Qontori Pte Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->libdir . '/authlib.php');
require_once($CFG->dirroot . '/auth/jmoodle/auth.php');

// It gives a warning if no context set, I guess it does nor matter which we use.
$PAGE->set_context(context_system::instance());

/** @var  $logged_in bool Moodle user logged in state */
$logged_in = false;

// Grab the GET params.
$token = optional_param('wstoken', '', PARAM_TEXT);
$username = optional_param('username', '', PARAM_TEXT);
$username = strtolower($username);

$auth = new auth_plugin_jmoodle();
/**
 * @var $joomla_token string|false Это должен быть токен юзера, id которого смотрим в настройках
 */
$joomla_token = $auth->getJoomlaUserWsToken();
/**
 * @var $joomla_url string Joomla host для запроса на проверку активной сессии пользователя на стороне Joomla.
 */
$joomla_url = $auth->config->joomla_host;

if (str_contains($joomla_url, '://') === false) {
    $joomla_url = '//' . $joomla_url;
}

$joomla_url = parse_url($joomla_url);
$joomla_url = (empty($joomla_url['scheme']) ? 'http' : $joomla_url['scheme']) . '://' . $joomla_url['host'];

if (empty($token)) {
    throw new Exception('There is no token specified', '403');
}
if (empty($joomla_token)) {
    throw new Exception('There is no Joomla token specified in JMoodle auth plugin config ', '403');
}

if ($token !== $joomla_token) {
    throw new Exception('Wrong Joomla token specified. You can\'t acceess to Moodle', '403');
}

// First check this is a jmoodle user.
if (!$user = get_complete_user_data('username', $username)) {
    throw new moodle_exception('cannotfinduser', '', '', $username);
}

$params = [
    'username' => $username,
    'token' => $token,
];


/**
 *  Проверяем активную сессию пользователя на стороне Joomla запросом к плагину
 * @var $logged array  array (size=4)
 *                          'success' => boolean true
 *                          'message' => null
 *                          'messages' => null
 *                          'data' =>
 *                              array (size=2)
 *                                  'username' => string 'ivan' (length=4)
 *                                  'logged_in' => boolean true
 */
$logged = $auth->request($joomla_url . '/index.php?option=com_ajax&plugin=wtjmoodleusersync&group=user&action=check_joomla_user_session&format=json', $params);
if ($logged['success'] && !empty($logged['data'])) // successful request into Joomla
{

    if ($logged['data']['username'] == $username) {
        /** @var  $logged_in_joomla bool true if joomla user is logged in */
        $logged_in_joomla = $logged['data']['logged_in'];

        if ($logged_in_joomla) {

            complete_user_login($user);

            if (!$user->suspended) {

                // Log the user in.
                complete_user_login($user);

//                \core\session\manager::apply_concurrent_login_limit($user->id, session_id());

                // sets the username cookie
                if (!empty($CFG->nolastloggedin)) {

                    // do not store last logged in user in cookie
                    // auth plugins can temporarily override this from loginpage_hook()
                    // do not save $CFG->nolastloggedin in database!

                } elseif (empty($CFG->rememberusername)) {

                    // no permanent cookies, delete old one if exists
                    set_moodle_cookie('');

                } else {

                    set_moodle_cookie($username);
                }

                // Call user_authenticated_hook.
                $authsenabled = get_enabled_auth_plugins();
                foreach ($authsenabled as $hau) {
                    $hauth = get_auth_plugin($hau);
                    $hauth->user_authenticated_hook($user, $username, "");
                }
            }
            $logged_in = true;
        }// logged in joomla == true
    }// valid username
}

//return [
//    'username' => $username,
//    'logged_in' => $logged_in,
//];