<?php
/**
 * @package       WT SEO Meta templates
 * @version       2.0.3
 * @Author        Sergey Tolkachyov, https://web-tolk.ru
 * @copyright     Copyright (C) 2023 Sergey Tolkachyov
 * @license       GNU/GPL http://www.gnu.org/licenses/gpl-3.0.html
 * @since         1.0.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\System\Wttelegrambot\Extension\Wttelegrambot;

return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param Container $container The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $subject = $container->get(DispatcherInterface::class);
                $config = (array)PluginHelper::getPlugin('system', 'wttelegrambot');
                $plugin = new Wttelegrambot($subject, $config);
                $plugin->setApplication(\Joomla\CMS\Factory::getApplication());
	            $plugin->setDatabase(\Joomla\CMS\Factory::getContainer()->get('DatabaseDriver'));
                return $plugin;
            }
        );
    }
};