<?php
/**
 * @package    WT Amo CRM library package
 * @version    1.3.0
 * @Author     Sergey Tolkachyov, https://web-tolk.ru
 * @copyright  (c) 2022 - September 2025 Sergey Tolkachyov. All rights reserved.
 * @license    GNU/GPL3 http://www.gnu.org/licenses/gpl-3.0.html
 * @since      1.0.0
 */

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\User\UserFactoryInterface;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\User\Wtamocrmusersync\Extension\Wtamocrmusersync;

defined('_JEXEC') or die;

return new class () implements ServiceProviderInterface {

	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function register(Container $container): void
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$subject = $container->get(DispatcherInterface::class);
				$config = (array) PluginHelper::getPlugin('user', 'wtamocrmusersync');

                $plugin = new Wtamocrmusersync($subject, $config);
				$plugin->setApplication(Factory::getApplication());
				$plugin->setDatabase(Factory::getContainer()->get(DatabaseInterface::class));
				$plugin->setUserFactory(Factory::getContainer()->get(UserFactoryInterface::class));

                return $plugin;
			}
		);
	}
};