<?php
/**
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on cookies.
 * @package     WT JoomShopping Favorite
 * @version     2.0.3
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2024 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since       1.0.0
 * @link        https://web-tolk.ru/en/dev/joomshopping/wt-joomshopping-favorite
 */

namespace Joomla\Module\Wtjshoppingfavorites\Site\Dispatcher;

defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\Jshopping\Site\Helper\Helper;
use Joomla\Registry\Registry;
use JSHelper;
use function defined;

class Dispatcher extends AbstractModuleDispatcher
{

	/**
	 * Returns the layout data.
	 *
	 * @return  array
	 *
	 * @since   1.0.0
	 */
	protected function getLayoutData(): array
	{
		$data             = parent::getLayoutData();
		$app              = $this->getApplication();
		$moduleHelper     = $this->app->bootModule('mod_wtjshoppingfavorites', 'site')
			->getHelper('WtjshoppingfavoritesHelper');
		$data['moduleId'] = $data['module']->id;
		if (!empty($data['params']->get('moduleclass_sfx', '')))
		{
			$data['moduleclass_sfx'] = htmlspecialchars($data['params']->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');
		}
		$data['product_ids'] = $moduleHelper::getProductList($data['params'], $app);

		$itemid = $moduleHelper->getItemid();
		if (empty($itemid))
		{
			$itemid = Helper::getDefaultItemid();
		}
		$data['itemid'] = '&Itemid=' . $itemid;

		$btn_icon_css_class = $data['params']->get('btn_icon_css_class', '');

		if (empty($btn_icon_css_class))
		{
			$plugin = PluginHelper::getPlugin('jshoppingproducts', 'wtjshoppingfavorites');
			if ($plugin)
			{
				$pluginParams       = new Registry($plugin->params);
				$btn_icon_css_class = $pluginParams->get('btn_icon_css_class');
			}
		}
		$data['btn_icon_css_class'] = $btn_icon_css_class;

		/**
		 * Take a css file for tmpl with the same name form media folder
		 */

		$tmpl_css      = explode(':', $data['params']->get('layout'));
		$tmpl_css_file = $tmpl_css[1];
		/* @var $wa WebAssetManager */
		$wa = $app->getDocument()->getWebAssetManager();
		if (file_exists('media/mod_wtjshoppingfavorites/css/' . $tmpl_css_file . '.css'))
		{
			$wa->registerAndUseStyle($data['module']->module . ':' . $tmpl_css_file, $data['module']->module . '/' . $tmpl_css_file . '.css');
		}
		else
		{
			$wa->registerAndUseStyle($data['module']->module . '.default', $data['module']->module . '/default.css');
		}

		return $data;
	}
}