<?php
/**
 * @package     WT Lightbox2.js
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @link 		https://web-tolk.ru/dev/joomla-plugins/wt-lightbox2-js
 * @license     GNU General Public License version 3 or later
 */
 
namespace Joomla\Plugin\System\Wtlightbox2js\Extension; 

\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;


class Wtlightbox2js extends CMSPlugin implements SubscriberInterface
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 *
	 * @since  3.9.0
	 */
	protected $autoloadLanguage = true;

	
	protected $allowLegacyListeners = false;
	
	
	/**
	 * @inheritDoc
	 *
	 * @return string[]
	 *
	 * @since 4.1.0
	 *
	 * @throws Exception
	 */
	public static function getSubscribedEvents(): array
	{
		$app = Factory::getApplication();

		$mapping  = [];

		if ($app->isClient('site'))
		{
			$mapping['onAfterInitialise'] = 'addFabricjsPreset';

		}

		return $mapping;
	}


	public function addFabricjsPreset()
	{
		// Only trigger in frontend
		if (Factory::getApplication()->isClient('site'))
		{
			/** @var Joomla\CMS\WebAsset\WebAssetManager $wa*/
			$wa = Factory::getDocument()->getWebAssetManager();
			$wa->getRegistry()->addRegistryFile('media/plg_system_wtlightbox2js/joomla.asset.json');
			return true;
		}
	}
}
