<?php
/**
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on coockies.
 * @package     WT JoomShopping Favorite
 * @version     1.1.0
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since       1.0.0
 * @link        https://web-tolk.ru/en/dev/joomshopping/wt-joomshopping-favorite.html
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Profiler\Profiler;

class JshoppingControllerwtjshoppingfavorites extends JshoppingControllerBase{

	public function display($cachable = false, $urlparams = false){
	            !JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>WT JoomShopping Favorites</strong>: '.__CLASS__.' '.__FUNCTION__.' start');
	  	    $this->view();
	            !JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>WT JoomShopping Favorites</strong>: '.__CLASS__.' '.__FUNCTION__.' end');
		}

	public function view()
		{
			$jshopConfig = JSFactory::getConfig();
			$lang        = Factory::getLanguage();
			$lang->load('plg_jshoppingproducts_wtjshoppingfavorites', JPATH_ADMINISTRATOR);
			PluginHelper::importPlugin('jshoppingproducts');
			$dispatcher = JDispatcher::getInstance();
			$dispatcher->trigger('onBeforeDisplayWtjshoppingfavorites', array(&$this));
			$view_name   = "wtjshoppingfavorites";
			$view_config = array("template_path" => JPATH_COMPONENT . "/templates/" . $jshopConfig->template . "/" . $view_name);
			$view        = $this->getView($view_name, getDocumentType(), '', $view_config);
			$view->setLayout("wtjshoppingfavorites");
			$view->assign('config', $jshopConfig);
			$app = Factory::getApplication();
			$product_ids = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, 'string'));

				if(!empty($product_ids)){
						$product     = JSFactory::getTable('product', 'jshop');
						$category    = JSFactory::getTable('category', 'jshop');
						$productlist = JSFactory::getModel('productList', 'jshop');

						foreach ($product_ids as $product_id)
						{
							$product->load($product_id);
							$category_id = $product->getCategory();
							JSFactory::getModel('productShop', 'jshop')->storeEndPages();
							$category->load($category_id);
							$category->products_page = '';
							JshopHelpersMetadata::category($category);
							$productlist->setModel($category);
							/*
							 * По умолчанию грузится количество товаров, ограниченное настройкамми пагинации
							 * Настройки - Товар - секция Список товаров - Количество товаров на странице.
							 * Чтобы получить массив со всеми товарами категории - убираем лимит,
							 * устанавливая $category->products_page в пустое значение
							 */
							$productlist->load();
							$products = $productlist->getProducts();
							for ($i = 0; $i < count($products); $i++)
							{
								if ($products[$i]->product_id == $product_id)
								{
									//добавляет кнопку избранного к товару в Избранном
									$dispatcher->trigger('onConstructJshopWtFavorite', array(&$products[$i]));
									$prods[] = $products[$i];
								}
							}
						}
						$view->assign('rows', $prods);
						$view->config->show_sort_product          = "0"; //Отключаем показ фильтров и сортировки
						$view->config->show_count_select_products = "0";
						$view->assign('template_block_list_product', $productlist->getTmplBlockListProduct());
						$view->assign('template_no_list_product', $productlist->getTmplNoListProduct());
						$view->assign('template_block_form_filter', $productlist->getTmplBlockFormFilter());
						$view->assign('template_block_pagination', $productlist->getTmplBlockPagination());
						$view->assign('count_product_to_row', $productlist->getCountProductsToRow());
						$view->assign('image_category_path', $jshopConfig->image_category_live_path);
						$view->assign('noimage', $jshopConfig->noimage);
						$view->assign('count_category_to_row', $category->getCountToRow());
						$view->assign('shippinginfo', SEFLink($jshopConfig->shippinginfourl, 1));
						$view->assign('total', $productlist->getTotal());

				} else {
					$view->assign('config', $jshopConfig);
				}
			$document = Factory::getDocument();
			appendPathWay(Text::_('WT_JSHOPPING_FAVORITES'));
			$document->setTitle(Text::_('WT_JSHOPPING_FAVORITES'));
	        $dispatcher->trigger('onBeforeDisplaywtjshoppingfavoritesView', array(&$view));
			$view->display();
    }

}
?>