<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2021 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
/*
 * Available products data you can echo
 *	$product->product_id
 *	$product->category_id
 *	$product->name
 *	$product->short_description
 *	$product->product_ean
 *	$product->manufacturer_code
 *	$product->image					full image url (thumb)
 *	$product->product_name_image					full image name without url
 *	$product->product_thumb_image					thumb image name without url
 *	$product->product_price
 *	$product->product_old_price
 *	$product->product_old_price
 *	$product->product_weight
 *	$product->average_rating
 *	$product->reviews_count
 *	$product->hits
 *	$product->template_block_product
 *	$product->product_link
 *	$product->buy_link
 *	$product->unlimited
 *
 *
 *	Try
 * */
// 	echo '<pre>';
// 	print_r($products);
// 	echo '</pre>';
/**
 * to see all products data
 */


if (!empty($products)) : ?>
	<div class="jshop last_seen_products<?php echo $moduleclass_sfx; ?>">
		<?php
		$i = 0;
		foreach ($products as $product) : ?>
			<?php if($params->get('products_count') > $i) :?>
				<article class="block_item">
						<?php if ($params->get('show_image', 1)) : ?>
							<div class="item_image">
								<?php if ($product->_label_image) : ?>
									<div class="product_label">
										<img src="<?php echo $product->_label_image ?>" alt="<?php echo $product->_label_name ?>" />
									</div>
								<?php endif; ?>
								<a href="<?php echo $product->product_link; ?>">
									<img class="img-fluid" src="<?php echo $product->image; ?>" alt="<?php echo $product->name ?>" title="<?php echo $product->name ?>" loading="lazy" width="<?php echo $jshopConfig->image_product_width;?>" height="<?php echo $jshopConfig->image_product_height;?>"/>
								</a>
							</div>
						<?php endif; ?>
							<?php if ($params->get('show_name', 1)) : ?>
								<div class="item_name">
									<a href="<?php echo $product->product_link ?>"><?php echo $product->name ?></a>
								</div>
							<?php endif; ?>
							<?php if ($params->get('show_price', 1)) : ?>
								<?php if ($params->get('show_old_price', 1) && !empty($product->product_old_price)) : ?>
									<s><?php echo formatprice($product->product_old_price); ?></s>
								<?php endif; ?>
								<?php if (!empty($product->product_price)) : ?>
									<div class="item_price">
										<?php echo formatprice($product->product_price); ?>
									</div>
								<?php endif; ?>
							<?php endif; ?>

						<?php if ($params->get('show_buy_button', 0) && !empty($product->buy_link)) : ?>
							<div class="buy_button">
								<a href="<?php echo $product->buy_link;?>"><?php echo _JSHOP_BUY;?></a>
							</div>
						<?php endif; ?>
				</article>
				<?php $i++; ?>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>
<?php else : ?>
	<?php echo Text::_('MOD_WT_JSHOPPING_LAST_SEEN_PRODUCTS_NO_PRODUCTS'); ?>
<?php endif; ?>
