<?php
/**
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on coockies.
 * @package     WT JoomShopping Favorite
 * @version     1.2.0
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since       1.0.0
 * @link        https://web-tolk.ru/en/dev/joomshopping/wt-joomshopping-favorite.html
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Profiler\Profiler;

class JshoppingControllerwtjshoppingfavorites extends JshoppingControllerBase{

	public function display($cachable = false, $urlparams = false){
	            !JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>WT JoomShopping Favorites</strong>: '.__CLASS__.' '.__FUNCTION__.' start');
	  	    $this->view();
	            !JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>WT JoomShopping Favorites</strong>: '.__CLASS__.' '.__FUNCTION__.' end');
		}

	public function view()
		{
			$jshopConfig = JSFactory::getConfig();
			$lang        = Factory::getLanguage();
			$lang->load('plg_jshoppingproducts_wtjshoppingfavorites', JPATH_ADMINISTRATOR);
			PluginHelper::importPlugin('jshoppingproducts');
			$dispatcher = JDispatcher::getInstance();
			$dispatcher->trigger('onBeforeDisplayWtjshoppingfavorites', array(&$this));
			$view_name   = "wtjshoppingfavorites";
			$view_config = array("template_path" => JPATH_COMPONENT . "/templates/" . $jshopConfig->template . "/" . $view_name);
			$view        = $this->getView($view_name, getDocumentType(), '', $view_config);
			$view->setLayout("wtjshoppingfavorites");
			$view->assign('config', $jshopConfig);
			$app = Factory::getApplication();
			$product_ids = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, 'string'));

				if(!empty($product_ids)){

					$wt_products = JModelLegacy::getInstance('wtproducts', 'jshop');
					$wt_products->loadProductsByIds($product_ids);
					$wt_products->addWtFavoritesButtonToProducts();

					$view->assign('rows', $wt_products->products);
					$view->config->show_sort_product          = "0"; //Отключаем показ фильтров и сортировки
					$view->config->show_count_select_products = "0";
					$view->assign('template_block_list_product', $wt_products->getTmplBlockListProduct());
					$view->assign('template_no_list_product', $wt_products->getTmplNoListProduct());
					$view->assign('template_block_form_filter', $wt_products->getTmplBlockFormFilter());
					$view->assign('template_block_pagination', $wt_products->getTmplBlockPagination());
					$view->assign('count_product_to_row', $jshopConfig->count_products_to_row);
					$view->assign('image_category_path', $jshopConfig->image_category_live_path);
					$view->assign('noimage', $jshopConfig->noimage);
					$view->assign('shippinginfo', SEFLink($jshopConfig->shippinginfourl, 1));
					$view->assign('total', $wt_products->getTotal());

				} else {
					$view->assign('config', $jshopConfig);
				}
			$document = Factory::getDocument();
			appendPathWay(Text::_('WT_JSHOPPING_FAVORITES'));
			$document->setTitle(Text::_('WT_JSHOPPING_FAVORITES'));
	        $dispatcher->trigger('onBeforeDisplaywtjshoppingfavoritesView', array(&$view));
			$view->display();
    }

}
?>