<?php 
/**
* @version      4.17.0 18.11.2017
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/
defined('_JEXEC') or die();
$order = $this->order;

?>
<div class="jshop myorderinfo">

    <?php print $this->_tmp_html_start;?>

    <div class="row shadow mb-3">
        <div class="col col-sm-6 col-md-3 d-flex flex-column justify-content-center align-items-center">
            <span class="order_number text-center">
                <span class="text-muted text-center"><?php echo _JSHOP_ORDER_NUMBER;?></span> <span class="h5 text-center"><strong><?php echo $order->order_number?></strong></span>
	            <?php print $order->_tmp_ext_order_number;?>
             </span>
            <span class="order_status text-center">
                <span class="badge text-dark"><?php print _JSHOP_ORDER_STATUS ?></span><span class="badge text-secondary"><?php print $order->status_name;?></span>
	            <?php print $order->_tmp_ext_status_name;?>
            </span>
        </div>


        <div class="col-sm-6 col-md-6">
            <div class="card-body">
                <p class="card-text"><strong><?php print _JSHOP_PRODUCTS ?>:</strong> <span><?php print count ($order->products); ?></span></p>
			    <?php if(!empty($order->_tmp_ext_prod_info)){?>
                    <p class="card-text"><?php print $order->_tmp_ext_prod_info;?></p>
			    <?php }?>
                <p class="card-text"><strong><?php print _JSHOP_EMAIL_BILL_TO; ?>:</strong> <?php print $order->f_name; ?> <?php print $order->l_name; ?></p>
			    <?php if(!empty($order->_tmp_ext_user_info)){?>
                    <p class="card-text"><?php print $order->_tmp_ext_user_info;?></p>
			    <?php }?>
                <p class="card-text"><strong><?php print _JSHOP_PRICE_TOTAL ?>:</strong> <?php print formatprice($order->order_total, $order->currency_code); ?></p>

                <p class="card-text"><small class="text-muted"><b><?php print _JSHOP_ORDER_DATE ?>:</b> <span><?php print formatdate($order->order_date, 0) ?></span></small></p>
            </div>
        </div>


	    <?php if ($this->config->order_send_pdf_client) : ?>
            <div class="downlod_order_invoice col col-md-3 d-flex justify-content-center align-items-center">
                <a class="btn btn-danger" target="_blank" href="<?php print $this->config->pdf_orders_live_path."/".$order->pdf_file;?>">
                    <i class="fas fa-file-pdf"></i> <?php print _JSHOP_DOWNLOAD_INVOICE?>
                </a>
            </div>
	    <?php endif; ?>

    </div>




    <div class = "row userinfo shadow mb-3 p-2">
        <div class = "col-12 col-md-6 userbillinfo">
            <ul class="jshop list-group">
                <li class="list-group-item">
                    <b><?php print _JSHOP_EMAIL_BILL_TO ?></b>
                </li>
				<?php if ($this->config_fields['firma_name']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_FIRMA_NAME?>:</strong><?php print $this->order->firma_name?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['f_name']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_FULL_NAME?>:</strong> <?php print $this->order->f_name?> <?php print $this->order->l_name?> <?php print $this->order->m_name?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['client_type']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_CLIENT_TYPE?>:</strong> <?php print $this->order->client_type_name;?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['firma_code']['display'] && ($this->order->client_type==2 || !$this->config_fields['client_type']['display'])){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_FIRMA_CODE?>:</strong> <?php print $this->order->firma_code?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['tax_number']['display'] && ($this->order->client_type==2 || !$this->config_fields['client_type']['display'])){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_VAT_NUMBER?>:</strong> <?php print $this->order->tax_number?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['birthday']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_BIRTHDAY?>:</strong> <?php print $this->order->birthday?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['home']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_HOME?>:</strong> <?php print $this->order->home?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['apartment']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_APARTMENT?>:</strong> <?php print $this->order->apartment?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['street']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_STREET_NR?>:</strong> <?php print $this->order->street?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['city']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_CITY?>:</strong> <?php print $this->order->city?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['state']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_STATE?>:</strong> <?php print $this->order->state?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['zip']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_ZIP?>:</strong> <?php print $this->order->zip?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['country']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_COUNTRY?>:</strong> <?php print $this->order->country?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['phone']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_TELEFON?>:</strong> <?php print $this->order->phone?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['mobil_phone']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_MOBIL_PHONE?>:</strong> <?php print $this->order->mobil_phone?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['fax']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_FAX?>:</strong> <?php print $this->order->fax?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['email']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_EMAIL?>:</strong> <?php print $this->order->email?>
                    </li>
				<?php } ?>

				<?php if ($this->config_fields['ext_field_1']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_EXT_FIELD_1?>:</strong> <?php print $this->order->ext_field_1?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['ext_field_2']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_EXT_FIELD_2?>:</strong> <?php print $this->order->ext_field_2?>
                    </li>
				<?php } ?>
				<?php if ($this->config_fields['ext_field_3']['display']){?>
                    <li class="list-group-item">
                        <strong><?php print _JSHOP_EXT_FIELD_3?>:</strong> <?php print $this->order->ext_field_3?>
                    </li>
				<?php } ?>
				<?php echo $this->tmp_fields?>
            </ul>
        </div>
        <div class = "col-12 col-md-6 userdeliveryinfo table-responsive">
			<?php if ($this->count_filed_delivery >0) {?>
                <ul class="list-group jshop userdeliveryinfo">

                    <li class="list-group-item">
                        <strong><?php print _JSHOP_EMAIL_SHIP_TO ?>
                    </li>
					<?php if ($this->config_fields['d_firma_name']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_FIRMA_NAME?>:</strong> <?php print $this->order->d_firma_name?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_f_name']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_FULL_NAME?> <?php print $this->order->d_f_name?> <?php print $this->order->d_l_name?> <?php print $this->order->d_m_name?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_birthday']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_BIRTHDAY?>:</strong> <?php print $this->order->d_birthday?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_home']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_HOME?>:</strong> <?php print $this->order->d_home?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_apartment']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_APARTMENT?>:</strong> <?php print $this->order->d_apartment?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_street']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_STREET_NR?>:</strong> <?php print $this->order->d_street?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_city']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_CITY?>:</strong> <?php print $this->order->d_city?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_state']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_STATE?>:</strong> <?php print $this->order->d_state?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_zip']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_ZIP ?>:</strong> <?php print $this->order->d_zip ?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_country']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_COUNTRY ?>:</strong> <?php print $this->order->d_country ?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_phone']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_TELEFON ?>:</strong> <?php print $this->order->d_phone ?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_mobil_phone']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_MOBIL_PHONE?>:</strong> <?php print $this->order->d_mobil_phone?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_fax']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_FAX ?>:</strong> <?php print $this->order->d_fax ?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_email']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_EMAIL ?>:</strong> <?php print $this->order->d_email ?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_ext_field_1']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_EXT_FIELD_1?>:</strong> <?php print $this->order->d_ext_field_1?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_ext_field_2']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_EXT_FIELD_2?>:</strong> <?php print $this->order->d_ext_field_2?>
                        </li>
					<?php } ?>
					<?php if ($this->config_fields['d_ext_field_3']['display']){?>
                        <li class="list-group-item">
                            <strong><?php print _JSHOP_EXT_FIELD_3?>:</strong> <?php print $this->order->d_ext_field_3?>
                        </li>
					<?php } ?>
					<?php echo $this->tmp_d_fields?>
                </ul>
			<?php } ?>
        </div>
		<?php print $this->_tmp_html_after_customer_info; ?>
    </div>
    <div class="row justify-content-end shadow mb-3 p-2">
        <div class="product_head col-12 col-lg-2 h3 mr-auto">
            <?php echo _JSHOP_PRODUCTS; ?>
        </div>
        <div class="product_head d-none d-lg-block col-lg-1 text-center">
		    <?php echo _JSHOP_SINGLEPRICE; ?>
        </div>
        <div class="product_head d-none d-lg-block col-lg-1  text-center">
		    <?php echo _JSHOP_NUMBER; ?>
        </div>
        <div class="product_head d-none d-lg-block col-lg-2 text-center">
		    <?php echo _JSHOP_PRICE_TOTAL; ?>
        </div>


    </div>
    <div class = "order_items">        
        <div class="jshop cart">

        <?php
        $i=1; $countprod = count($order->items);
        foreach($order->items as $key_id=>$prod){
            $files = unserialize($prod->files);
            ?>

        <div class="row shadow mb-3">
	        <?php if(!empty($prod->thumb_image)) : ?>
                <div class="col-12 col-sm-4 col-md-6 col-lg-2 p-1">
                    <img src = "<?php echo $this->config->image_product_live_path;?>/<?php echo $prod->thumb_image; ?>" alt = "<?php echo htmlspecialchars($prod->product_name);?>" class = "card-img" />
                </div>
	        <?php endif;?>
            <div class="col-12 col-sm-8 col-md-6 col-lg-6">
                <div class="card-body">
                    <span class="d-md-none text-muted"><?php print _JSHOP_ITEM; ?></span>
                    <h4 class="card-title"><?php print $prod->product_name;?>

	                    <?php if ($this->config->show_product_code_in_order){?>
                            <small class="product_code">
                                <span class="d-md-none">
				                    <?php print _JSHOP_EAN_PRODUCT?>
                                </span>
                                <span class="data">
				                    <?php print $prod->product_ean?>
                                </span>
                            </small>
	                    <?php } ?>
                    </h4>
	                <?php if ($prod->manufacturer!=''){?>
                        <div class="manufacturer">
			                <?php print _JSHOP_MANUFACTURER?>:
                            <span><?php print $prod->manufacturer?></span>
                        </div>
	                <?php }?>
	                <?php if ($this->config->manufacturer_code_in_cart && $prod->manufacturer_code){?>
                        <div class="manufacturer_code"><?php print _JSHOP_MANUFACTURER_CODE ?>: <span><?php print $prod->manufacturer_code?></span></div>
	                <?php }?>
                    <div class="attribs">
		                <?php print sprintAtributeInOrder($prod->product_attributes).sprintFreeAtributeInOrder($prod->product_freeattributes);?>
		                <?php print $prod->_ext_attribute_html;?>
                    </div>
	                <?php if (count($files)){?>
                        <div class="filelist">
			                <?php foreach($files as $file){?>
                                <div class="file d-flex flex-column d-lg-inline-block">
                                    <a class="download btn btn-sm btn-success" href="<?php print JURI::root()?>index.php?option=com_jshopping&controller=product&task=getfile&oid=<?php print $this->order->order_id?>&id=<?php print $file->id?>&hash=<?php print $this->order->file_hash;?>">
		                                <?php print _JSHOP_DOWNLOAD;?>
                                    </a>
                                        <span class="descr text-muted">
                                            <i class="fas fa-file"></i> <?php echo  $file->file;?> <?php print $file->file_descr?>
                                        </span>
                                </div>
			                <?php }?>
                        </div>
	                <?php }?>
	                <?php print $prod->_ext_file_html;?>
                </div>
            </div>
            <div class="col-6 col-sm-4 col-md-4 col-lg-1 p-1 d-flex flex-column justify-content-center align-items-center">
                <div class="d-lg-none text-muted">
		            <?php print _JSHOP_SINGLEPRICE; ?>
                </div>
                <div class="data d-flex flex-column align-items-center">
		            <?php print formatprice($prod->product_item_price, $order->currency_code) ?>
		            <?php print $prod->_ext_price_html?>

		            <?php if ($this->config->show_tax_product_in_cart && $prod->product_tax>0){?>
                        <span class="taxinfo"><?php print productTaxInfo($prod->product_tax, $order->display_price);?></span>
		            <?php }?>

		            <?php if ($this->config->cart_basic_price_show && $prod->basicprice>0){?>
                        <div class="basic_price">
				            <?php print _JSHOP_BASIC_PRICE?>:
                            <span><?php print sprintBasicPrice($prod);?></span>
                        </div>
		            <?php }?>

                </div>
            </div>

            <div class="col-6 col-sm-4 col-md-4 col-lg-1 p-1 d-flex flex-column justify-content-center align-items-center">
                <div class="d-lg-none text-muted">
		            <?php print _JSHOP_NUMBER; ?>
                </div>
                <div class="data">
		            <?php print formatqty($prod->product_quantity);?><?php print $prod->_qty_unit;?>
                </div>
            </div>

            <div class="col-12 col-sm-4 col-md-4 col-lg-2 p-1 d-flex flex-column justify-content-center align-items-center">
                <span class="d-lg-none text-muted"><?php print strtolower(_JSHOP_PRICE_TOTAL); ?></span>
                <span class="h3"><?php print formatprice($prod->product_item_price * $prod->product_quantity); ?></span>
            </div>
        </div>

    </div>

        <?php $i++; } ?>
        </div>
    </div>



<div class="row shadow mb-3 p-3">
	<?php if ($this->config->show_weight_order){?>
        <div class="weightorder col-6 col-sm-4 col-md-3 col-lg-2">
			<?php print _JSHOP_WEIGHT_PRODUCTS?>:
            <span><?php print formatweight($this->order->weight);?></span>
        </div>
	<?php }?>

<div class="col-12 col-lg-4 order-1 order-lg-3">
    <table class = "jshop jshop_subtotal table table-bordered table-hover table-striped">
		<?php if (!$this->hide_subtotal){?>
            <tr class="subtotal">
                <td class = "name">
					<?php print _JSHOP_SUBTOTAL ?>
                </td>
                <td class = "value">
					<?php print formatprice($order->order_subtotal, $order->currency_code);?>
					<?php print $this->_tmp_ext_subtotal?>
                </td>
            </tr>
		<?php } ?>

		<?php print $this->_tmp_html_after_subtotal?>

		<?php if ($order->order_discount > 0){ ?>
            <tr class="discount">
                <td class = "name">
					<?php print _JSHOP_RABATT_VALUE ?><?php print $this->_tmp_ext_discount_text?>
                </td>
                <td class = "value">
					<?php print formatprice(-$order->order_discount, $order->currency_code);?>
					<?php print $this->_tmp_ext_discount?>
                </td>
            </tr>
		<?php } ?>

		<?php if (!$this->config->without_shipping || $order->order_shipping > 0){?>
            <tr class="shipping">
                <td class = "name">
					<?php print _JSHOP_SHIPPING_PRICE;?>
                </td>
                <td class = "value">
					<?php print formatprice($order->order_shipping, $order->currency_code);?>
					<?php print $this->_tmp_ext_shipping?>
                </td>
            </tr>
		<?php } ?>

		<?php if (!$this->config->without_shipping && ($order->order_package>0 || $this->config->display_null_package_price)){?>
            <tr class="package">
                <td class="name">
					<?php print _JSHOP_PACKAGE_PRICE?>
                </td>
                <td class="value">
					<?php print formatprice($order->order_package, $order->currency_code); ?>
					<?php print $this->_tmp_ext_shipping_package?>
                </td>
            </tr>
		<?php } ?>

		<?php if ($this->order->order_payment > 0){?>
            <tr class="payment">
                <td class = "name">
					<?php print $this->order->payment_name;?>
                </td>
                <td class = "value">
					<?php print formatprice($this->order->order_payment, $order->currency_code);?>
					<?php print $this->_tmp_ext_payment?>
                </td>
            </tr>
		<?php } ?>

		<?php if (!$this->config->hide_tax){ ?>
			<?php foreach($order->order_tax_list as $percent=>$value){?>
                <tr class="tax">
                    <td class = "name">
						<?php print displayTotalCartTaxName($order->display_price);?>
						<?php if ($this->show_percent_tax) print formattax($percent)."%"?>
                    </td>
                    <td class = "value">
						<?php print formatprice($value, $order->currency_code);?>
						<?php print $this->_tmp_ext_tax[$percent]?>
                    </td>
                </tr>
			<?php }?>
		<?php }?>
        <tr class="total">
            <td class = "name">
				<?php print $this->text_total; ?>
            </td>
            <td class = "value">
				<?php print formatprice($order->order_total, $order->currency_code);?>
				<?php print $this->_tmp_ext_total?>
            </td>
        </tr>
		<?php print $this->_tmp_html_after_total?>
    </table>
</div>


    <?php if (!$this->config->without_shipping){?>
        <div class="col-12 col-lg-4 order-2 order-lg-1">
            <div class="shipping_block_info">
                <div class="shipping_head">
                    <b><?php print _JSHOP_SHIPPING_INFORMATION ?></b>
                </div>

                <div class="shipping_info">
				    <?php print nl2br($order->shipping_info);?>
                </div>

                <div class="order_shipping_params">
				    <?php print nl2br($order->shipping_params);?>
                </div>

			    <?php if ($order->delivery_time_name){?>
                    <div class="delivery_time">
					    <?php echo _JSHOP_DELIVERY_TIME.": ".$order->delivery_time_name?>
                    </div>
			    <?php }?>

			    <?php if ($order->delivery_date_f){?>
                    <div class="delivery_date">
					    <?php echo _JSHOP_DELIVERY_DATE.": ".$order->delivery_date_f?>
                    </div>
			    <?php }?>
			    <?php print $this->_tmp_html_shipping_block_info_end;?>
            </div>
        </div>
   <?php }?>






    <?php if (!$this->config->without_payment){?>
        <div class="col-12 col-lg-4 order-3 order-lg-2">
            <div class="payment_block_info">
                <div class="payment_head">
                    <b><?php print _JSHOP_PAYMENT_INFORMATION ?></b>
                </div>
                <div class="payment_info">
				    <?php print $order->payment_name;?>
                </div>
                <div class="order_payment_params">
				    <?php print nl2br($order->payment_params);?>
				    <?php print $order->payment_description;?>
                </div>
            </div>
        </div>
   <?php }?>



	    <?php if ($order->order_add_info){ ?>
                <div class="col-12 col-lg-4">
                        <div class="order_comment">
                            <div class="order_comment_head">
                                <b><?php print _JSHOP_ORDER_COMMENT ?></b>
                            </div>
                            <div class="order_comment_info">
                                <?php print $order->order_add_info ?>
                            </div>
                        </div>
                </div>
	       <?php } ?>

	    <?php print $this->_tmp_html_after_comment;?>

</div>
<div class="row shadow mb-3 p-3">
<div class="col-12 history">
            <h4><?php print _JSHOP_ORDER_HISTORY ?></h4>
            <div class="order_history table-responsive">
                <table class="table">
                    <?php foreach($order->history as $history){?>
                        <tr>
                            <td class="date">
                                <?php  print formatdate($history->status_date_added, 0); ?>
                            </td>
                            <td class="name">
                                <?php print $history->status_name ?>
                            </td>
                            <td class="comment">
                                <?php print nl2br($history->comments)?>
                            </td>
                        </tr>
                    <?php } ?>
                </table>
            </div>

</div>
<?php print $this->_tmp_html_after_history;?>

</div>





    





    
    <?php if ($this->allow_cancel){?>
        <div class="button_cancel">
            <a href="<?php print SEFLink('index.php?option=com_jshopping&controller=user&task=cancelorder&order_id='.$order->order_id)?>" class = "btn btn-danger">
                <?php print _JSHOP_CANCEL_ORDER?>
            </a>
        </div>
    <?php }?>
    
    <?php print $this->_tmp_html_end;?>

</div>