<?php 
/**
* @version      4.16.3 25.08.2017
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/
defined('_JEXEC') or die();
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\PluginHelper;
?>



<article class="block_product col p-0">
	<div class="product productitem_<?php print $product->product_id?> card h-100">
		<div class="row no-gutters h-100">
			<?php print $product->_tmp_var_start?>
			<div class="col-4 col-sm-12 image">
					<?php if ($product->image){?>
						<div class="image_block">
							<?php print $product->_tmp_var_image_block;?>
							<?php if ($product->label_id){?>
								<div class="product_label">
									<?php if ($product->_label_image){?>
										<?php echo HTMLHelper::image($product->_label_image, htmlspecialchars($product->name),'loading="lazy"',0,0);?>
									<?php }else{?>
										<span class="label_name"><?php print $product->_label_name;?></span>
									<?php }?>
								</div>
							<?php }?>
							<a href="<?php print $product->product_link?>">
								<?php echo HTMLHelper::image($product->image, htmlspecialchars($product->name),'title="'.htmlspecialchars($product->name).'" class="jshop_img img-fluid" loading="lazy" width="'.$this->config->image_product_width.'" height="'.$this->config->image_product_height.'"',0,0);?>
							</a>
						</div>
					<?php }?>

					<?php if ($this->allow_review){?>
						<?php if (!$this->config->hide_product_rating){?>
							<div class="review_mark">
								<?php print showMarkStar($product->average_rating);?>
							</div>
						<?php }?>
						<div class="count_commentar">
							<?php print sprintf(_JSHOP_X_COMENTAR, $product->reviews_count);?>
						</div>
					<?php }?>

					<?php print $product->_tmp_var_bottom_foto;?>

			</div>
			<div class="col-8 col-sm-12 d-flex flex-column">
				<div class="card-body d-flex flex-column p-1 p-sm-2">
					<div class="name d-flex flex-column">
						<a href="<?php print $product->product_link?>">
							<h2 class="h6"><?php print $product->name?></h2>
						</a>
						<?php if ($this->config->product_list_show_product_code){?>
							<span class="jshop_code_prod">(<?php print _JSHOP_EAN?>: <span><?php print $product->product_ean;?></span>)</span>
						<?php }?>
					</div>



					<div class = "oiproduct mt-auto">
						<?php /* Убрали отображение количества в категории товаров - 01.06.2021
						if ($product->product_quantity <=0 && !$this->config->hide_text_product_not_available){?>

					<div class="not_available badge badge-danger"><?php print _JSHOP_PRODUCT_NOT_AVAILABLE;?></div>
				<?php }*/?>

						<?php if ($product->product_old_price > 0){?>
							<div class="old_price">
								<?php if ($this->config->product_list_show_price_description) print _JSHOP_OLD_PRICE.": ";?>
								<s><?php print formatprice($product->product_old_price)?><?php print $product->_tmp_var_old_price_ext?></s>
							</div>
						<?php }?>

						<?php print $product->_tmp_var_bottom_old_price;?>

						<?php if ($product->product_price_default > 0 && $this->config->product_list_show_price_default){?>
							<div class="default_price">
								<?php //print _JSHOP_DEFAULT_PRICE.": ";?>
								<span><?php print formatprice($product->product_price_default)?></span>
							</div>
						<?php }?>

						<?php if ($product->_display_price){?>
							<div class = "jshop_price h4 font-weight-bold text-center">
								<?php //if ($this->config->product_list_show_price_description) print _JSHOP_PRICE.": ";?>
								<?php if ($product->show_price_from) print _JSHOP_FROM." ";?>
								<span><?php print formatprice($product->product_price);?><?php print $product->_tmp_var_price_ext;?></span>
							</div>
						<?php }?>

						<?php print $product->_tmp_var_bottom_price;?>

						<?php if($this->config->show_tax_in_product && $product->tax > 0 || $this->config->show_plus_shipping_in_product):?>
							<div class="price_extra_info">
								<?php if ($this->config->show_tax_in_product && $product->tax > 0){?>
									<span class="taxinfo"><?php print productTaxInfo($product->tax);?></span>
								<?php }?>

								<?php if ($this->config->show_plus_shipping_in_product){?>
									<span class="plusshippinginfo"><?php print sprintf(_JSHOP_PLUS_SHIPPING, $this->shippinginfo);?></span>
								<?php }?>
							</div>
						<?php endif;?>
						<?php if ($product->basic_price_info['price_show']){?>
							<div class="base_price">
								<?php print _JSHOP_BASIC_PRICE?>:
								<?php if ($product->show_price_from && !$this->config->hide_from_basic_price) print _JSHOP_FROM;?>
								<span><?php print formatprice($product->basic_price_info['basic_price'])?> / <?php print $product->basic_price_info['name'];?></span>
							</div>
						<?php }?>

						<?php if ($product->manufacturer->name){?>
							<div class="manufacturer_name">
								<?php print _JSHOP_MANUFACTURER;?>:
								<span><?php print $product->manufacturer->name?></span>
							</div>
						<?php }?>

						<?php if ($this->config->manufacturer_code_in_product_list && $product->manufacturer_code){?>
							<div class="manufacturer_code">
								<?php print _JSHOP_MANUFACTURER_CODE?>:
								<span><?php print $product->manufacturer_code?></span>
							</div>
						<?php }?>

						<?php if ($this->config->product_list_show_weight && $product->product_weight > 0){?>
							<div class="productweight">
								<?php print _JSHOP_WEIGHT?>:
								<span><?php print formatweight($product->product_weight)?></span>
							</div>
						<?php }?>

						<?php if ($product->delivery_time != ''){?>
							<div class="deliverytime">
								<?php print _JSHOP_DELIVERY_TIME?>:
								<span><?php print $product->delivery_time?></span>
							</div>
						<?php }?>

						<?php if (is_array($product->extra_field) && count($product->extra_field) > 0){?>
							<div class="extra_fields">
								<?php foreach($product->extra_field as $extra_field){?>
									<div>
										<span class="label-name font-weight-bold"><?php print $extra_field['name'];?>:</span>
										<span class="data"><?php print $extra_field['value'];?></span>
									</div>
								<?php }?>
							</div>
						<?php }?>

						<?php if ($product->vendor){?>
							<div class="vendorinfo">
								<?php print _JSHOP_VENDOR?>:
								<a href="<?php print $product->vendor->products?>"><?php print $product->vendor->shop_name?></a>
							</div>
						<?php }?>

						<?php /* Убрали показ количества товаров в категории - 1.06.2021
				if ($this->config->product_list_show_qty_stock){?>
					<div class="qty_in_stock">
						<?php print _JSHOP_QTY_IN_STOCK?>:
						<span><?php print sprintQtyInStock($product->qty_in_stock)?></span>
					</div>
				<?php }*/?>
					</div>
				</div>
				<div class="card-footer d-flex flex-column align-items-center bg-white border-0 mt-auto px-0">
					<div class="buttons d-flex">
						<?php print $product->_tmp_var_top_buttons; ?>

						<?php if ($product->buy_link):?>
								<?php if(PluginHelper::isEnabled('jshoppingproducts', 'wt_jshopping_products_ajax_add_to_cart') === true):
								// Если товар в корзине - пишем текст и количество.
								if($product->wt_jshopping_products_ajax_add_to_cart){

									$btn_text = $product->wt_jshopping_products_ajax_add_to_cart_btn_text. ' '.$product->wt_jshopping_products_ajax_add_to_cart_prod_qty;
									$btn_css_class = $product->wt_jshopping_products_ajax_add_to_cart_btn_css_class;
								} else {
									$btn_text = _JSHOP_BUY;
									$btn_css_class = '';
								}
								?>
									<button type="button" class="btn btn-sm btn-mz-blue-outline button_buy wt_jshopping_products_ajax_add_to_cart <?php echo $btn_css_class;?>" data-product-id="<?php echo $product->product_id;?>" data-product-category-id="<?php echo $product->category_id;?>">
										<i class="fa fa-cart-arrow-down"></i> <span class="btn_text_for_product_added"><?php echo $btn_text;?></span>
									</button>
								<?php  else:?>
									<a class="btn btn-sm btn-mz-blue-outline button_buy" href="<?php print $product->buy_link?>">
										<i class="fa fa-cart-arrow-down"></i> <?php print _JSHOP_BUY?>
									</a>
								<?php endif;?>

							<?php else:?>


							<button class="contact_form_modal_btn price_request btn btn-sm btn-outline-dark button_buy"
									type="button"
									data-toggle="modal"
									data-target="#contact_form_modal"
									data-form-title="Запрос цены"
									data-form-subtitle="Вас интересует товар "
									data-fields="email,phone"
									data-fields-required="phone"
									data-product-id="<?php print $product->product_id?>">
								<i class="fas fa-question"></i> Запрос цены
							</button>
						<?php endif;?>
						<button class="contact_form_modal_btn price_request btn btn-sm button_buy"
								type="button"
								data-toggle="modal"
								data-target="#contact_form_modal"
								data-form-title="Быстрый заказ"
								data-form-subtitle="Вас интересует товар "
								data-fields="phone"
								data-fields-required="phone"
								data-product-id="<?php print $product->product_id?>">
							<i class="fas fa-phone"></i>
						</button>

						<?php /*?>
						<a class="btn btn-info btn-sm  button_detail" href="<?php print $product->product_link?>">
							<?php print _JSHOP_DETAIL?>
						</a>
						<?php */?>
						<?php print $product->_tmp_var_buttons;?>

						<?php print $product->_tmp_var_bottom_buttons;?>
					</div>
					<?php if(!empty($product->short_description)):?>
						<div class="description text-muted shadow bg-white py-1">
							<?php print $product->short_description?>
						</div>
					<?php endif;?>

				</div>
			</div>
			<?php echo $product->_tmp_var_end?>
		</div>
	</div>

</article>
