<?php
/**
* @version      4.16.3 25.05.2017
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/ 
defined('_JEXEC') or die();
$product = $this->product;
include(dirname(__FILE__)."/load.js.php");
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\CMS\HTML\HTMLHelper;

/*
*	Добавляем опции для скрипта форм обратной связи с данными товара
*	- название
*	- артикул
*	- цена
*	- url миниатюры изображения
*
*	HTML-каркас формы находится в модуле типа HTML-код. Обработчик - плагин Radical Form.
*   Поля в форме скрываются/показываются динамически через js, который находится в том же модуле.
*   Заголовки модального окна, темы письма, подзаголовок берутся из data-атрибутов кнопки.
*
*	Пример-мануал https://web-tolk.ru/blog/integratsiya-form-obratnoj-svyazi-i-bitriks24-na-sajte-joomla.html
*	https://hika.su/rasshireniya/radical-form
*/

$doc = Factory::getDocument();
$jshop_image = $this->image_product_path . '/' . $this->images[0]->image_name;
$product_array = array($this->product->product_id => array(
	'jshop_product_name' => $this->product->name,
	'jshop_product_image_url' => $jshop_image
)
);

if ($this->config->show_product_code){
	$product_array[$this->product->product_id]['ean'] = $this->product->getEan();
}
//echo '<pre>';
//print_r($this);
//echo '</pre>';

/*
 * Начинается дикий кастом.
 * В выгрузке товара из 1С есть признак "архивный" - то есть товар уже снят с производства и не поставляется.
 * Но, при этом на сайте остается, так как может собирать НЧ запросы. Выводим лычку о том,
 * что товар не поставляется.
 */



$doc->addScriptOptions('jshop_products_details',$product_array);
?>

<div class="jshop productfull" id="comjshop">
    <div class="mb-4 row">
    <div class="col-12">
        <h1 class="h2"><?php print $this->product->name?><?php if ($this->config->show_product_code){?> <span class="jshop_code_prod">(<?php print _JSHOP_EAN?>: <span id="product_code"><?php print $this->product->getEan();?></span>)</span><?php }?></h1>
	</div>
		<div class="col-12">
			<?php print $this->_tmp_product_html_start;?>
			<?php if ($this->config->display_button_print) print printContent();?>
			<?php include(dirname(__FILE__)."/ratingandhits.php");?>
		</div>
        <div class="col-12 row jshop">
            <div class="col-12 col-md-6 image_middle">
            
                <?php print $this->_tmp_product_html_before_image;?>
                
                <?php if ($product->label_id){?>
                    <div class="product_label">
                        <?php if ($product->_label_image){?>
                            <img src="<?php print $product->_label_image?>" alt="<?php print htmlspecialchars($product->_label_name)?>" />
                        <?php }else{?>
                            <span class="label_name"><?php print $product->_label_name;?></span>
                        <?php }?>
                    </div>
                <?php }?>
                
                <span id='list_product_image_middle'>
                    <?php print $this->_tmp_product_html_body_image?>
                    
                    <?php if(!count($this->images)){?>
                        <img id = "main_image" src = "<?php print $this->image_product_path?>/<?php print $this->noimage?>" alt = "<?php print htmlspecialchars($this->product->name)?>" class="img-fluid"/>
                    <?php }?>
                    
                    <?php foreach($this->images as $k=>$image){?>
                        <a class="lightbox" id="main_image_full_<?php print $image->image_id?>" href="<?php print $this->image_product_path?>/<?php print $image->image_full;?>" <?php if ($k!=0){?>style="display:none"<?php }?> title="<?php print htmlspecialchars($image->_title)?>">
	                        <?php echo HTMLHelper::image($this->image_product_path.'/'.$image->image_name, htmlspecialchars($product->name),'id="main_image_'.$image->image_id.' title="'.htmlspecialchars($image->_title).'" class="img-fluid" loading="lazy" width="'.$this->config->image_product_width.'" height="'.$this->config->image_product_height.'"',0,0);?>
                            <div class="text_zoom">
                                <img src="<?php print $this->path_to_image?>search.png" alt="zoom" />
                                <?php print _JSHOP_ZOOM_IMAGE?>
                            </div>
                        </a>
                    <?php }?>
                </span>
                
                <?php print $this->_tmp_product_html_after_image;?>


	            <?php print $this->_tmp_product_html_before_image_thumb;?>

                <span id='list_product_image_thumb' class="d-flex flex-wrap">
                    <?php if ( (count($this->images)>1) ) {?>
	                    <?php foreach($this->images as $k=>$image){?>
                            <img class="jshop_img_thumb" src="<?php print $this->image_product_path?>/<?php print $image->image_thumb?>" alt="<?php print htmlspecialchars($image->_title)?>" title="<?php print htmlspecialchars($image->_title)?>" onclick="showImage(<?php print $image->image_id?>)" />
	                    <?php }?>
                    <?php }?>
                </span>

	            <?php print $this->_tmp_product_html_after_image_thumb;?>

            </div>
            
            <div class = "col-12 col-md-6 jshop_img_description pt-3">

				<div class="alert alert-warning p-3 text-center">
					<p>Данный товар снят с производства и больше не поставляется.</p>
					<p>Мы можем подобрать для Вас современный аналог.</p>


					<?php
					/*
					 * Кнопка запроса подбора аналога устаревшего товара
					 */
					?>
					<button class="contact_form_modal_btn price_request btn btn-warning"
							type="button"
							data-toggle="modal"
							data-target="#contact_form_modal"
							data-form-title="Подобрать аналог"
							data-form-subtitle="Вас интересует товар "
							data-fields="email,phone"
							data-fields-required="phone"
							data-product-id="<?php echo $this->product->product_id;?>">Подобрать аналог</button>

				</div>
	            <?php print $this->_tmp_product_html_before_buttons;?>
	            <?php print $this->_tmp_product_html_buttons;?>
	            <?php print $this->_tmp_product_html_after_buttons;?>
<!--				<button type="button" class="btn btn-sm" id="compare_button--><?php //echo $product->product_id;?><!--" data-compare="--><?php //echo $product->product_id;?><!--"><i class="far fa-chart-bar"></i></button>-->



	            <?php if ($this->config->product_show_manufacturer && $this->product->manufacturer_info->name!=""){?>
					<div class="manufacturer_name mt-2">
						<span class="font-weight-bold"><?php print _JSHOP_MANUFACTURER?>:</span> <a href="<?php print SEFLink('index.php?option=com_jshopping&controller=manufacturer&task=view&manufacturer_id='.$this->product->product_manufacturer_id, 2);?>"><?php print $this->product->manufacturer_info->name?></a>
					</div>
        		<?php }?>
	            <?php if ($this->config->product_show_weight && $this->product->product_weight > 0){?>
					<div class="productweight mt-2">
						<span class="font-weight-bold"><?php print _JSHOP_WEIGHT?>:</span> <span id="block_weight"><?php print formatweight($this->product->getWeight())?></span>
					</div>
	            <?php }?>
				<div class="category_name mt-2">
					<span class="font-weight-bold"><?php print _JSHOP_CATEGORY?>:</span>
					<?php
					$product_categories = $this->product->product_categories;
					$currentLang = Factory::getLanguage();
					$langTag = $currentLang->getTag();
					$category = Table::getInstance('category', 'jshop');
					$categories = "";
					$category_name = "";
					foreach ($product_categories as $product_category){
						$category_link = SEFLink('index.php?option=com_jshopping&controller=category&task=view&category_id=' . $product_category->category_id, 1);
						$category->load($product_category->category_id);
						$category_name .= $category->{'name_'.$langTag}.', ';
						$categories.='<a href="'.$category_link.'">'.$category->{'name_'.$langTag}.'</a> ';
					}
					echo $categories;
					?>

				</div>
            </div>
        </div>

        <?php if ($this->product->product_url!=""){?>
            <div class="prod_url">
                <a target="_blank" class="btn btn-sm btn-outline-danger" href="<?php print $this->product->product_url;?>"><?php print _JSHOP_READ_MORE?></a>
            </div>
        <?php }?>


		
		<?php if ($this->config->manufacturer_code_in_product_detail && $this->product->getManufacturerCode()!=""){?>
            <div class="manufacturer_code">
                <?php print _JSHOP_MANUFACTURER_CODE?>: <span id="manufacturer_code"><?php print $this->product->getManufacturerCode()?></span>
            </div>
        <?php }?>
        
        <?php print $this->_tmp_product_html_before_atributes;?>

        <?php if (count($this->attributes)) : ?>
            <div class="jshop_prod_attributes jshop">
                <?php foreach($this->attributes as $attribut) : ?>
                    <?php if ($attribut->grshow){?>
                        <div>
                            <span class="attributgr_name"><?php print $attribut->groupname?></span>
                        </div>
                    <?php }?>               
                    <div class="row-fluid row-attr-<?php print $attribut->attr_id?>">
                        <div class="col-md-2 attributes_title">
                            <span class="attributes_name"><?php print $attribut->attr_name?>:</span>
                            <span class="attributes_description"><?php print $attribut->attr_description;?></span>
                        </div>
                        <div class = "col-md-10">
                            <span id='block_attr_sel_<?php print $attribut->attr_id?>'>
                                <?php print $attribut->selects?>
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <?php print $this->_tmp_product_html_after_atributes;?>

        <?php if (isset($this->product->freeattributes) && count($this->product->freeattributes)){?>
            <div class="prod_free_attribs jshop">
                <?php foreach($this->product->freeattributes as $freeattribut){?>
                    <div class="row-fluid row-free-attr-<?php print $freeattribut->id?>">
                        <div class="span2 name">
                            <span class="freeattribut_name"><?php print $freeattribut->name;?></span>
                            <?php if ($freeattribut->required){?><span>*</span><?php }?>
                            <span class="freeattribut_description"><?php print $freeattribut->description;?></span>
                        </div>
                        <div class="span10 field">
                            <?php print $freeattribut->input_field;?>
                        </div>
                    </div>
                <?php }?>
                <?php if ($this->product->freeattribrequire) {?>
                    <div class="requiredtext">* <?php print _JSHOP_REQUIRED?></div>
                <?php }?>
            </div>
        <?php }?>
        
        <?php print $this->_tmp_product_html_after_freeatributes;?>
	</div>
	<div class="productfull_info">
		<ul class="nav nav-tabs mt-4" id="myTab" role="tablist">
			<li class="nav-item" role="presentation">
				<a class="nav-link active" id="home-tab" data-toggle="tab" href="#productfull_description" role="tab" aria-controls="Product description" aria-selected="true"><?php echo _JSHOP_DESCRIPTION;?></a>
			</li>
			<?php
			// Может быть пустой массив - тогда будет показываться вкладка без данных. Нам это не нужно.
			if (is_array($this->product->extra_field) && count($this->product->extra_field) > 0):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="extra_fields-tab" data-toggle="tab" href="#productfull_extra_fields" role="tab" aria-controls="Extra fields" aria-selected="false"><?php echo _JSHOP_EXTRA_FIELDS;?></a>
				</li>
			<?php endif;?>
			<?php if (count ($this->demofiles)):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="list_product_demofiles-tab" data-toggle="tab" href="#list_product_demofiles" role="tab" aria-controls="list_product_demofiles" aria-selected="false"><?php echo _JSHOP_FILES;?></a>
				</li>
			<?php endif;?>

			<?php if (count($this->videos)):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="product_videos-tab" data-toggle="tab" href="#productfull_videos" role="tab" aria-controls="productfull_videos" aria-selected="false"><?php echo _JSHOP_TABS_VIDEO;?></a>
				</li>
			<?php endif;?>

			<?php if ($this->allow_review):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="product_review-tab" data-toggle="tab" href="#productfull_review" role="tab" aria-controls="productfull_review" aria-selected="false"><?php echo _JSHOP_REVIEWS;?></a>
				</li>
			<?php endif;?>
		</ul>
		<div class="tab-content" id="productfull_info">
			<section class="tab-pane fade show active jshop_prod_description" id="productfull_description" role="tabpanel" aria-labelledby="productfull_description-tab">
				<h2 class="h4 mt-4"><?php echo _JSHOP_DESCRIPTION;?></h2>
				<?php print $this->product->description; ?>
			</section>


			<?php if (is_array($this->product->extra_field) && count($this->product->extra_field) > 0):?>
				<section class="tab-pane fade extra_fields" id="productfull_extra_fields" role="tabpanel" aria-labelledby="productfull_extra_fields-tab">
						<h2 class="h4 mt-4"><?php echo _JSHOP_EXTRA_FIELDS;?></h2>
						<?php foreach($this->product->extra_field as $extra_field){?>
							<?php if ($extra_field['grshow']){?>
								<div class='block_efg'>
								<div class='extra_fields_group'><?php print $extra_field['groupname']?></div>
							<?php }?>
									<div class="extra_fields_el row my-md-2 py-2">
										<div class="extra_fields_name font-weight-bold col-12 col-sm-4"><?php print $extra_field['name'];?>
											<?php if ($extra_field['description']):?>
												<small class="extra_fields_description text-muted">
													<?php print $extra_field['description'];?>
												</small>
											<?php endif; ?>
										</div>
										<div class="extra_fields_value col-12 col-sm-8">
											<?php print $extra_field['value'];?>
										</div>
									</div>
							<?php if ($extra_field['grshowclose']){?>
								</div>
							<?php }?>
						<?php }?>
					<?php print $this->_tmp_product_html_after_ef;?>

				</section>
			<?php endif;?>

			<?php if (count ($this->demofiles)):?>
				<section class="tab-pane fade productfull_demofiles" id="list_product_demofiles" role="tabpanel" aria-labelledby="productfull_demofiles-tab">
					<h2 class="h4 mt-4"><?php echo _JSHOP_FILES;?></h2>
					<?php print $this->_tmp_product_html_before_demofiles; ?>
						<?php include(dirname(__FILE__)."/demofiles.php");?>
				</section>
			<?php endif;?>

			<?php if (count($this->videos)):?>
				<section class="tab-pane fade productfull_videos" id="productfull_videos" role="tabpanel" aria-labelledby="productfull_videos-tab">
					<h2 class="h4 mt-4"><?php echo _JSHOP_TABS_VIDEO;?></h2>
					<?php if (count($this->videos)){?>
						<?php foreach($this->videos as $k=>$video){?>
							<?php if ($video->video_code){ ?>
								<div class="video_full my-3" id="productfull_video_<?php print $k?>"><?php echo $video->video_code?></div>
							<?php } else { ?>
								<div class="video_full my-3" id="productfull_video_<?php print $k?>">
									<video class="productfull_video img-fluid" id="productfull_video_<?php print $k?>" poster="<?php print $this->video_image_preview_path."/"; if ($video->video_preview) print $video->video_preview; else print 'video.gif'?>" controls="controls">
										<source src="<?php print $this->video_product_path?>/<?php print $video->video_name?>">
									</video>
								</div>
							<?php } ?>
						<?php } ?>
					<?php }?>
					<?php print $this->_tmp_product_html_after_video;?>
				</section>
			<?php endif;?>

			<?php if ($this->allow_review):?>
				<section class="tab-pane fade productfull_review" id="productfull_review" role="tabpanel" aria-labelledby="productfull_review-tab">
					<h2 class="h4 mt-4"><?php echo _JSHOP_REVIEWS;?></h2>
					<?php
						print $this->_tmp_product_html_before_review;
						include(dirname(__FILE__)."/review.php");
					?>
				</section>
			<?php endif;?>
		</div>
	</div>


        <?php if ($this->product->vendor_info){?>
            <div class="vendorinfo">
                <?php print _JSHOP_VENDOR?>: <?php print $this->product->vendor_info->shop_name?> (<?php print $this->product->vendor_info->l_name." ".$this->product->vendor_info->f_name;?>),
                ( 
                <?php if ($this->config->product_show_vendor_detail){?><a href="<?php print $this->product->vendor_info->urlinfo?>"><?php print _JSHOP_ABOUT_VENDOR?></a>,<?php }?> 
                <a href="<?php print $this->product->vendor_info->urllistproducts?>"><?php print _JSHOP_VIEW_OTHER_VENDOR_PRODUCTS?></a> )
            </div>
        <?php }?>





    
    <?php if ($this->config->product_show_button_back){?>
        <div class="button_back">
            <input type="button" class="btn button" value="<?php print _JSHOP_BACK;?>" onclick="<?php print $this->product->button_back_js_click;?>" />
        </div>
    <?php }?>
	<?php if (count($this->related_prod)):?>
		<section class="productfull_related">
			<?php
				print $this->_tmp_product_html_before_related;
				include(dirname(__FILE__) . "/related.php");
			?>
		</section>
	<?php endif;?>
    <?php print $this->_tmp_product_html_end;?>
</div>