<?php
/**
* @version      4.16.3 25.05.2017
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/ 
defined('_JEXEC') or die();
$product = $this->product;
include(dirname(__FILE__)."/load.js.php");
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\CMS\HTML\HTMLHelper;
?>
<div class="jshop productfull" id="comjshop">
    <form name="product" method="post" action="<?php print $this->action?>" enctype="multipart/form-data" autocomplete="off" class="mb-4 row">
    <div class="col-12">
        <h1 class="h2"><?php print $this->product->name?><?php if ($this->config->show_product_code){?> <span class="jshop_code_prod">(<?php print _JSHOP_EAN?>: <span id="product_code"><?php print $this->product->getEan();?></span>)</span><?php }?></h1>
	</div>
		<div class="col-12">
			<?php print $this->_tmp_product_html_start;?>
			<?php if ($this->config->display_button_print) print printContent();?>
			<?php include(dirname(__FILE__)."/ratingandhits.php");?>
		</div>
        <div class="col-12 row jshop">
            <div class="col-12 col-md-6 image_middle">
            
                <?php print $this->_tmp_product_html_before_image;?>
                
                <?php if ($product->label_id){?>
                    <div class="product_label">
                        <?php if ($product->_label_image){?>
                            <img src="<?php print $product->_label_image?>" alt="<?php print htmlspecialchars($product->_label_name)?>" />
                        <?php }else{?>
                            <span class="label_name"><?php print $product->_label_name;?></span>
                        <?php }?>
                    </div>
                <?php }?>
                
                <span id='list_product_image_middle'>
                    <?php print $this->_tmp_product_html_body_image?>
                    
                    <?php if(!count($this->images)){?>
                        <img id = "main_image" src = "<?php print $this->image_product_path?>/<?php print $this->noimage?>" alt = "<?php print htmlspecialchars($this->product->name)?>" class="img-fluid"/>
                    <?php }?>
                    
                    <?php foreach($this->images as $k=>$image){?>
                        <a class="lightbox" id="main_image_full_<?php print $image->image_id?>" href="<?php print $this->image_product_path?>/<?php print $image->image_full;?>" <?php if ($k!=0){?>style="display:none"<?php }?> title="<?php print htmlspecialchars($image->_title)?>">
	                        <?php echo HTMLHelper::image($this->image_product_path.'/'.$image->image_name, htmlspecialchars($product->name),'id="main_image_'.$image->image_id.' title="'.htmlspecialchars($image->_title).'" class="img-fluid" loading="lazy" width="'.$this->config->image_product_width.'" height="'.$this->config->image_product_height.'"',0,0);?>
                            <div class="text_zoom">
                                <img src="<?php print $this->path_to_image?>search.png" alt="zoom" />
                                <?php print _JSHOP_ZOOM_IMAGE?>
                            </div>
                        </a>
                    <?php }?>
                </span>
                
                <?php print $this->_tmp_product_html_after_image;?>


	            <?php print $this->_tmp_product_html_before_image_thumb;?>

                <span id='list_product_image_thumb' class="d-flex flex-wrap">
                    <?php if ( (count($this->images)>1) ) {?>
	                    <?php foreach($this->images as $k=>$image){?>
                            <img class="jshop_img_thumb" src="<?php print $this->image_product_path?>/<?php print $image->image_thumb?>" alt="<?php print htmlspecialchars($image->_title)?>" title="<?php print htmlspecialchars($image->_title)?>" onclick="showImage(<?php print $image->image_id?>)" />
	                    <?php }?>
                    <?php }?>
                </span>

	            <?php print $this->_tmp_product_html_after_image_thumb;?>

            </div>
            
            <div class = "col-12 col-md-6 jshop_img_description">

	            <?php if ($this->product->product_is_add_price){?>
                    <div class="price_prod_qty_list_head"><?php print _JSHOP_PRICE_FOR_QTY?></div>
                    <table class="price_prod_qty_list">
			            <?php foreach($this->product->product_add_prices as $k=>$add_price){?>
                            <tr>
                                <td class="qty_from" <?php if ($add_price->product_quantity_finish==0){?>colspan="3"<?php } ?>>
						            <?php if ($add_price->product_quantity_finish==0) print _JSHOP_FROM?>
						            <?php print $add_price->product_quantity_start?>
						            <?php print $this->product->product_add_price_unit?>
                                </td>

					            <?php if ($add_price->product_quantity_finish > 0){?>
                                    <td class="qty_line"> - </td>
					            <?php } ?>

					            <?php if ($add_price->product_quantity_finish > 0){?>
                                    <td class="qty_to">
							            <?php print $add_price->product_quantity_finish?> <?php print $this->product->product_add_price_unit?>
                                    </td>
					            <?php } ?>

                                <td class="qty_price">
									<span id="pricelist_from_<?php print $add_price->product_quantity_start?>">
										<?php print formatprice($add_price->price)?><?php print $add_price->ext_price?>
									</span>
                                    <span class="per_piece">/ <?php print $this->product->product_add_price_unit?></span>
                                </td>
					            <?php print $add_price->_tmp_var?>
                            </tr>
			            <?php }?>
                    </table>
	            <?php }?>

                <div class="old_price" <?php if ($this->product->product_old_price == 0){?>style="display:none"<?php }?>>
		            <?php print _JSHOP_OLD_PRICE?>:
                    <span class="old_price" id="old_price">
						<?php print formatprice($this->product->product_old_price)?>
						<?php print $this->product->_tmp_var_old_price_ext; ?>
					</span>
                </div>

	            <?php if ($this->product->product_price_default > 0 && $this->config->product_list_show_price_default){?>
                    <div class="default_price"><?php print _JSHOP_DEFAULT_PRICE?>: <span id="pricedefault"><?php print formatprice($this->product->product_price_default)?></span></div>
	            <?php }?>

	            <?php print $this->_tmp_product_html_before_price;?>

	            <?php if ($this->product->_display_price){?>
                    <div class="prod_price h3">
						<span class="text-lowercase"><?php print _JSHOP_PRICE?>:</span>
                        <span id="block_price">
							<?php print formatprice($this->product->getPriceCalculate())?>
							<?php print $this->product->_tmp_var_price_ext;?>
						</span>
                    </div>
	            <?php }?>

				<?php //Кастомное решение! В общий не сувать
					if($this->product->getPriceCalculate() == 0):?>
					<button class="contact_form_modal_btn price_request btn btn-outline-danger"
							type="button"
							data-toggle="modal"
							data-target="#contact_form_modal"
							data-form-title="Запрос цены"
							data-form-subtitle="Вас интересует товар "
							data-fields="email,phone"
							data-fields-required="phone"
							data-product-id="<?php echo $this->product->product_id;?>">Запрос цены</button>

					<?php endif;?>

	            <?php print $this->product->_tmp_var_bottom_price;?>

	            <?php if ($this->product->product_basic_price_show){?>
                    <div class="prod_base_price"><?php print _JSHOP_BASIC_PRICE?>: <span id="block_basic_price"><?php print formatprice($this->product->product_basic_price_calculate)?></span> / <?php print $this->product->product_basic_price_unit_name;?></div>
	            <?php }?>

	            <?php print $this->product->_tmp_var_bottom_allprices;?>


	            <?php print $this->_tmp_product_html_before_buttons;?>

	            <?php if (!$this->hide_buy){?>
                    <div class="prod_buttons d-flex align-items-center" style="<?php print $this->displaybuttons?>">

                        <div class="prod_qty mr-1"><?php print _JSHOP_QUANTITY?>: </div>

                        <div class="prod_qty_input btn-group d-flex">
							<button type="button" class="btn btn-sm" onclick="this.parentNode.querySelector('input[type=number]').stepDown()">−</button>
                            <input type="number" name="quantity" id="quantity" min="1" onchange="reloadPrices();" class="form-control" value="<?php print $this->default_count_product?>" /><?php print $this->_tmp_qty_unit;?>
							<button type="button" class="btn btn-sm" onclick="this.parentNode.querySelector('input[type=number]').stepUp()">+</button>
                        </div>

                        <div class="buttons product-buttons">

		            <?php if(PluginHelper::isEnabled('jshoppingproducts', 'wt_jshopping_products_ajax_add_to_cart') === true):

						// Если товар в корзине - пишем текст и количество.
			            if($product->wt_jshopping_products_ajax_add_to_cart){
				            $btn_text = $product->wt_jshopping_products_ajax_add_to_cart_btn_text. ' '.$product->wt_jshopping_products_ajax_add_to_cart_prod_qty;
				            $btn_css_class = $product->wt_jshopping_products_ajax_add_to_cart_btn_css_class;
			            } else {
				            $btn_text = _JSHOP_ADD_TO_CART;
				            $btn_css_class = '';
			            }
			            ?>
						<button type="button" class="btn btn-sm btn-mz-blue-outline button_buy wt_jshopping_products_ajax_add_to_cart <?php echo $btn_css_class;?>" data-product-id="<?php echo $product->product_id;?>" data-product-category-id="<?php echo $product->getCategory();?>">
							<i class="fa fa-cart-arrow-down"></i> <span class="btn_text_for_product_added"><?php echo $btn_text;?></span>
						</button>
					<?php else:?>
						<button type="submit" class="btn btn-warning button btn-buy" onclick="jQuery('#to').val('cart');" ><i class="fa fa-cart-arrow-down"></i> <span class="btn_text_for_product_added"><?php echo $btn_text;?></span></button>
					<?php endif;?>


				            <?php if ($this->enable_wishlist){?>
								<button type="submit" class="btn button btn-wishlist" onclick="jQuery('#to').val('wishlist');" ><?php print _JSHOP_ADD_TO_WISHLIST?></button>
				            <?php }?>
						<?php /*

 						Кнопка для быстрого заказа
 						Статья https://web-tolk.ru/blog/razrabotka-form-obratnoj-svyazi-dlya-magazinov-na-joomla-3.html
 							?>
							<button class="contact_form_modal_btn price_request btn btn-sm button_buy"
									type="button"
									data-toggle="modal"
									data-target="#contact_form_modal"
									data-form-title="Быстрый заказ"
									data-form-subtitle="Вас интересует товар "
									data-fields="phone"
									data-fields-required="phone"
									data-product-id="<?php print $product->product_id?>">
								<i class="fas fa-phone"></i>
							</button>
	                        <?php */?>
				            <?php print $this->_tmp_product_html_buttons;?>
                        </div>

                        <div id="jshop_image_loading" style="display:none"></div>
                    </div>
	            <?php }?>
	            <?php print $this->_tmp_product_html_after_buttons;?>
	            <?php if (!$this->config->hide_text_product_not_available){ ?>
					<div class = "not_available badge badge-danger" id="not_available"><?php print $this->available?></div>
	            <?php }?>

	            <?php if ($this->config->product_show_qty_stock){?>
					<div class="qty_in_stock mt-2">
						<span class="font-weight-bold"><?php print _JSHOP_QTY_IN_STOCK?>:</span>
						<span id="product_qty"><?php print sprintQtyInStock($this->product->qty_in_stock);?></span>
					</div>
	            <?php }?>
	            <?php /*if ($this->config->product_show_manufacturer_logo && $this->product->manufacturer_info->manufacturer_logo!=""){?>
					<div class="manufacturer_logo">
						<a class="media" href="<?php print SEFLink('index.php?option=com_jshopping&controller=manufacturer&task=view&manufacturer_id='.$this->product->product_manufacturer_id, 2);?>">
							<img class="mr-3" style="height:100px;" src="<?php print $this->config->image_manufs_live_path."/".$this->product->manufacturer_info->manufacturer_logo?>" alt="<?php print htmlspecialchars($this->product->manufacturer_info->name);?>" title="<?php print htmlspecialchars($this->product->manufacturer_info->name);?>" />
							<span class="media-body"><?php print htmlspecialchars($this->product->manufacturer_info->name);?></span>
						</a>
					</div>
	            <?php }*/?>
	            <?php if ($this->config->product_show_manufacturer && $this->product->manufacturer_info->name!=""){?>
					<div class="manufacturer_name mt-2">
						<span class="font-weight-bold"><?php print _JSHOP_MANUFACTURER?>:</span> <a href="<?php print SEFLink('index.php?option=com_jshopping&controller=manufacturer&task=view&manufacturer_id='.$this->product->product_manufacturer_id, 2);?>"><?php print $this->product->manufacturer_info->name?></a>
					</div>
        		<?php }?>
	            <?php if ($this->config->show_tax_in_product && $this->product->product_tax > 0){?>
					<span class="taxinfo"><?php print productTaxInfo($this->product->product_tax);?></span>
	            <?php }?>

	            <?php if ($this->config->show_plus_shipping_in_product){?>
					<span class="plusshippinginfo"><?php print sprintf(_JSHOP_PLUS_SHIPPING, $this->shippinginfo);?></span>
	            <?php }?>

	            <?php if (!empty($this->product->delivery_time)){?>
					<div class="deliverytime mt-2" <?php if ($product->hide_delivery_time){?>style="display:none"<?php }?>>
						<span class="font-weight-bold"><?php print _JSHOP_DELIVERY_TIME?>:</span> <span id="deliverytime"><?php print $this->product->delivery_time?></span>
					</div>
	            <?php }?>

	            <?php if ($this->config->product_show_weight && $this->product->product_weight > 0){?>
					<div class="productweight mt-2">
						<span class="font-weight-bold"><?php print _JSHOP_WEIGHT?>:</span> <span id="block_weight"><?php print formatweight($this->product->getWeight())?></span>
					</div>
	            <?php }?>
				<div class="category_name mt-2">
					<span class="font-weight-bold"><?php print _JSHOP_CATEGORY?>:</span>
					<?php
					$product_categories = $this->product->product_categories;
					$currentLang = Factory::getLanguage();
					$langTag = $currentLang->getTag();
					$category = Table::getInstance('category', 'jshop');
					$categories = "";
					$category_name = "";
					foreach ($product_categories as $product_category){
						$category_link = SEFLink('index.php?option=com_jshopping&controller=category&task=view&category_id=' . $product_category->category_id, 1);
						$category->load($product_category->category_id);
						$category_name .= $category->{'name_'.$langTag}.', ';
						$categories.='<a href="'.$category_link.'">'.$category->{'name_'.$langTag}.'</a> ';
					}
					echo $categories;
					?>

				</div>
            </div>
        </div>

        <?php if ($this->product->product_url!=""){?>
            <div class="prod_url">
                <a target="_blank" class="btn btn-sm btn-outline-danger" href="<?php print $this->product->product_url;?>"><?php print _JSHOP_READ_MORE?></a>
            </div>
        <?php }?>


		
		<?php if ($this->config->manufacturer_code_in_product_detail && $this->product->getManufacturerCode()!=""){?>
            <div class="manufacturer_code">
                <?php print _JSHOP_MANUFACTURER_CODE?>: <span id="manufacturer_code"><?php print $this->product->getManufacturerCode()?></span>
            </div>
        <?php }?>
        
        <?php print $this->_tmp_product_html_before_atributes;?>

        <?php if (count($this->attributes)) : ?>
            <div class="jshop_prod_attributes jshop">
                <?php foreach($this->attributes as $attribut) : ?>
                    <?php if ($attribut->grshow){?>
                        <div>
                            <span class="attributgr_name"><?php print $attribut->groupname?></span>
                        </div>
                    <?php }?>               
                    <div class="row-fluid row-attr-<?php print $attribut->attr_id?>">
                        <div class="col-md-2 attributes_title">
                            <span class="attributes_name"><?php print $attribut->attr_name?>:</span>
                            <span class="attributes_description"><?php print $attribut->attr_description;?></span>
                        </div>
                        <div class = "col-md-10">
                            <span id='block_attr_sel_<?php print $attribut->attr_id?>'>
                                <?php print $attribut->selects?>
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <?php print $this->_tmp_product_html_after_atributes;?>

        <?php if (isset($this->product->freeattributes) && count($this->product->freeattributes)){?>
            <div class="prod_free_attribs jshop">
                <?php foreach($this->product->freeattributes as $freeattribut){?>
                    <div class="row-fluid row-free-attr-<?php print $freeattribut->id?>">
                        <div class="span2 name">
                            <span class="freeattribut_name"><?php print $freeattribut->name;?></span>
                            <?php if ($freeattribut->required){?><span>*</span><?php }?>
                            <span class="freeattribut_description"><?php print $freeattribut->description;?></span>
                        </div>
                        <div class="span10 field">
                            <?php print $freeattribut->input_field;?>
                        </div>
                    </div>
                <?php }?>
                <?php if ($this->product->freeattribrequire) {?>
                    <div class="requiredtext">* <?php print _JSHOP_REQUIRED?></div>
                <?php }?>
            </div>
        <?php }?>
        
        <?php print $this->_tmp_product_html_after_freeatributes;?>

		<input type="hidden" name="to" id='to' value="cart" />
		<input type="hidden" name="product_id" id="product_id" value="<?php print $this->product->product_id?>" />
		<input type="hidden" name="category_id" id="category_id" value="<?php print $this->category_id?>" />
	</form>
	<div class="productfull_info">
		<ul class="nav nav-tabs mt-4" id="myTab" role="tablist">
			<li class="nav-item" role="presentation">
				<a class="nav-link active" id="home-tab" data-toggle="tab" href="#productfull_description" role="tab" aria-controls="Product description" aria-selected="true"><?php echo _JSHOP_DESCRIPTION;?></a>
			</li>
			<?php
			// Может быть пустой массив - тогда будет показываться вкладка без данных. Нам это не нужно.
			if (is_array($this->product->extra_field) && count($this->product->extra_field) > 0):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="extra_fields-tab" data-toggle="tab" href="#productfull_extra_fields" role="tab" aria-controls="Extra fields" aria-selected="false"><?php echo Text::_('WT_JSHOP_EXTRA_FIELDS');?></a>
				</li>
			<?php endif;?>
			<?php if (count ($this->demofiles)):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="list_product_demofiles-tab" data-toggle="tab" href="#list_product_demofiles" role="tab" aria-controls="list_product_demofiles" aria-selected="false"><?php echo Text::_('WT_JSHOP_FILES');?></a>
				</li>
			<?php endif;?>

			<?php if (count($this->videos)):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="product_videos-tab" data-toggle="tab" href="#productfull_videos" role="tab" aria-controls="productfull_videos" aria-selected="false"><?php echo _JSHOP_TABS_VIDEO;?></a>
				</li>
			<?php endif;?>

			<?php if ($this->allow_review):?>
				<li class="nav-item" role="presentation">
					<a class="nav-link" id="product_review-tab" data-toggle="tab" href="#productfull_review" role="tab" aria-controls="productfull_review" aria-selected="false"><?php echo _JSHOP_REVIEWS;?></a>
				</li>
			<?php endif;?>
		</ul>
		<div class="tab-content" id="productfull_info">
			<section class="tab-pane fade show active jshop_prod_description" id="productfull_description" role="tabpanel" aria-labelledby="productfull_description-tab">
				<h2 class="h4 mt-4"><?php echo _JSHOP_DESCRIPTION;?></h2>
				<?php print $this->product->description; ?>
			</section>


			<?php if (is_array($this->product->extra_field) && count($this->product->extra_field) > 0):?>
				<section class="tab-pane fade extra_fields" id="productfull_extra_fields" role="tabpanel" aria-labelledby="productfull_extra_fields-tab">
						<h2 class="h4 mt-4"><?php echo Text::_('WT_JSHOP_EXTRA_FIELDS');?></h2>
						<?php foreach($this->product->extra_field as $extra_field){?>
							<?php if ($extra_field['grshow']){?>
								<div class='block_efg'>
								<div class='extra_fields_group'><?php print $extra_field['groupname']?></div>
							<?php }?>
									<div class="extra_fields_el row my-md-2 py-2">
										<div class="extra_fields_name font-weight-bold col-12 col-sm-4"><?php print $extra_field['name'];?>
											<?php if ($extra_field['description']):?>
												<small class="extra_fields_description text-muted">
													<?php print $extra_field['description'];?>
												</small>
											<?php endif; ?>
										</div>
										<div class="extra_fields_value col-12 col-sm-8">
											<?php print $extra_field['value'];?>
										</div>
									</div>
							<?php if ($extra_field['grshowclose']){?>
								</div>
							<?php }?>
						<?php }?>
					<?php print $this->_tmp_product_html_after_ef;?>

				</section>
			<?php endif;?>

			<?php if (count ($this->demofiles)):?>
				<section class="tab-pane fade productfull_demofiles" id="list_product_demofiles" role="tabpanel" aria-labelledby="productfull_demofiles-tab">
					<h2 class="h4 mt-4"><?php echo Text::_('WT_JSHOP_FILES');?></h2>
					<?php print $this->_tmp_product_html_before_demofiles; ?>
						<?php include(dirname(__FILE__)."/demofiles.php");?>
				</section>
			<?php endif;?>

			<?php if (count($this->videos)):?>
				<section class="tab-pane fade productfull_videos" id="productfull_videos" role="tabpanel" aria-labelledby="productfull_videos-tab">
					<h2 class="h4 mt-4"><?php echo _JSHOP_TABS_VIDEO;?></h2>
					<?php if (count($this->videos)){?>
						<?php foreach($this->videos as $k=>$video){?>
							<?php if ($video->video_code){ ?>
								<div class="video_full my-3" id="productfull_video_<?php print $k?>"><?php echo $video->video_code?></div>
							<?php } else { ?>
								<div class="video_full my-3" id="productfull_video_<?php print $k?>">
									<video class="productfull_video img-fluid" id="productfull_video_<?php print $k?>" poster="<?php print $this->video_image_preview_path."/"; if ($video->video_preview) print $video->video_preview; else print 'video.gif'?>" controls="controls">
										<source src="<?php print $this->video_product_path?>/<?php print $video->video_name?>">
									</video>
								</div>
							<?php } ?>
						<?php } ?>
					<?php }?>
					<?php print $this->_tmp_product_html_after_video;?>
				</section>
			<?php endif;?>

			<?php if ($this->allow_review):?>
				<section class="tab-pane fade productfull_review" id="productfull_review" role="tabpanel" aria-labelledby="productfull_review-tab">
					<h2 class="h4 mt-4"><?php echo _JSHOP_REVIEWS;?></h2>
					<?php
						print $this->_tmp_product_html_before_review;
						include(dirname(__FILE__)."/review.php");
					?>
				</section>
			<?php endif;?>
		</div>
	</div>


        <?php if ($this->product->vendor_info){?>
            <div class="vendorinfo">
                <?php print _JSHOP_VENDOR?>: <?php print $this->product->vendor_info->shop_name?> (<?php print $this->product->vendor_info->l_name." ".$this->product->vendor_info->f_name;?>),
                ( 
                <?php if ($this->config->product_show_vendor_detail){?><a href="<?php print $this->product->vendor_info->urlinfo?>"><?php print _JSHOP_ABOUT_VENDOR?></a>,<?php }?> 
                <a href="<?php print $this->product->vendor_info->urllistproducts?>"><?php print _JSHOP_VIEW_OTHER_VENDOR_PRODUCTS?></a> )
            </div>
        <?php }?>





    
    <?php if ($this->config->product_show_button_back){?>
        <div class="button_back">
            <input type="button" class="btn button" value="<?php print _JSHOP_BACK;?>" onclick="<?php print $this->product->button_back_js_click;?>" />
        </div>
    <?php }?>
	<?php if (count($this->related_prod)):?>
		<section class="productfull_related">
			<?php
				print $this->_tmp_product_html_before_related;
				include(dirname(__FILE__) . "/related.php");
			?>
		</section>
	<?php endif;?>
    <?php print $this->_tmp_product_html_end;?>
</div>